/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo.subscription;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;
import xsquash4gitlab.com.apollographql.apollo.subscription.ApolloOperationMessageSerializer;
import xsquash4gitlab.com.apollographql.apollo.subscription.OperationClientMessage;
import xsquash4gitlab.com.apollographql.apollo.subscription.OperationMessageSerializer;
import xsquash4gitlab.com.apollographql.apollo.subscription.OperationServerMessage;
import xsquash4gitlab.com.apollographql.apollo.subscription.SubscriptionTransport;
import xsquash4gitlab.kotlin.Metadata;
import xsquash4gitlab.kotlin.jvm.JvmOverloads;
import xsquash4gitlab.kotlin.jvm.internal.DefaultConstructorMarker;
import xsquash4gitlab.kotlin.jvm.internal.Intrinsics;
import xsquash4gitlab.okhttp3.Request;
import xsquash4gitlab.okhttp3.Response;
import xsquash4gitlab.okhttp3.WebSocket;
import xsquash4gitlab.okio.Buffer;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;
import xsquash4gitlab.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002'(B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\r\u0010\u0018\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0019J\u0017\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0017\u0010\u001e\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u001fH\u0000\u00a2\u0006\u0002\b J\r\u0010!\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010%\u001a\u00020&*\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lxsquash4gitlab/com/apollographql/apollo/subscription/WebSocketSubscriptionTransport;", "Lxsquash4gitlab/com/apollographql/apollo/subscription/SubscriptionTransport;", "webSocketRequest", "Lxsquash4gitlab/okhttp3/Request;", "webSocketConnectionFactory", "Lxsquash4gitlab/okhttp3/WebSocket$Factory;", "callback", "Lxsquash4gitlab/com/apollographql/apollo/subscription/SubscriptionTransport$Callback;", "serializer", "Lxsquash4gitlab/com/apollographql/apollo/subscription/OperationMessageSerializer;", "(Lokhttp3/Request;Lokhttp3/WebSocket$Factory;Lcom/apollographql/apollo/subscription/SubscriptionTransport$Callback;Lcom/apollographql/apollo/subscription/OperationMessageSerializer;)V", "webSocket", "Ljava/util/concurrent/atomic/AtomicReference;", "Lxsquash4gitlab/okhttp3/WebSocket;", "getWebSocket$apollo_runtime", "()Ljava/util/concurrent/atomic/AtomicReference;", "webSocketListener", "Lxsquash4gitlab/com/apollographql/apollo/subscription/WebSocketSubscriptionTransport$WebSocketListener;", "getWebSocketListener$apollo_runtime", "connect", "", "disconnect", "message", "Lxsquash4gitlab/com/apollographql/apollo/subscription/OperationClientMessage;", "onClosed", "onClosed$apollo_runtime", "onFailure", "t", "", "onFailure$apollo_runtime", "onMessage", "Lxsquash4gitlab/com/apollographql/apollo/subscription/OperationServerMessage;", "onMessage$apollo_runtime", "onOpen", "onOpen$apollo_runtime", "release", "send", "serializeToJson", "", "Factory", "WebSocketListener", "apollo-runtime"})
public final class WebSocketSubscriptionTransport
implements SubscriptionTransport {
    @NotNull
    private final Request webSocketRequest;
    @NotNull
    private final WebSocket.Factory webSocketConnectionFactory;
    @NotNull
    private final SubscriptionTransport.Callback callback;
    @NotNull
    private final OperationMessageSerializer serializer;
    @NotNull
    private final AtomicReference<WebSocket> webSocket;
    @NotNull
    private final AtomicReference<WebSocketListener> webSocketListener;

    @JvmOverloads
    public WebSocketSubscriptionTransport(@NotNull Request webSocketRequest, @NotNull WebSocket.Factory webSocketConnectionFactory, @NotNull SubscriptionTransport.Callback callback, @NotNull OperationMessageSerializer serializer) {
        Intrinsics.checkParameterIsNotNull(webSocketRequest, "webSocketRequest");
        Intrinsics.checkParameterIsNotNull(webSocketConnectionFactory, "webSocketConnectionFactory");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        this.webSocketRequest = webSocketRequest;
        this.webSocketConnectionFactory = webSocketConnectionFactory;
        this.callback = callback;
        this.serializer = serializer;
        this.webSocket = new AtomicReference();
        this.webSocketListener = new AtomicReference();
    }

    public /* synthetic */ WebSocketSubscriptionTransport(Request request, WebSocket.Factory factory2, SubscriptionTransport.Callback callback, OperationMessageSerializer operationMessageSerializer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            operationMessageSerializer = ApolloOperationMessageSerializer.INSTANCE;
        }
        this(request, factory2, callback, operationMessageSerializer);
    }

    @NotNull
    public final AtomicReference<WebSocket> getWebSocket$apollo_runtime() {
        return this.webSocket;
    }

    @NotNull
    public final AtomicReference<WebSocketListener> getWebSocketListener$apollo_runtime() {
        return this.webSocketListener;
    }

    @Override
    public void connect() {
        WebSocketListener webSocketListener = new WebSocketListener(this);
        boolean bl = this.webSocketListener.compareAndSet(null, webSocketListener);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already connected";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.webSocket.set(this.webSocketConnectionFactory.newWebSocket(this.webSocketRequest, webSocketListener));
    }

    @Override
    public void disconnect(@NotNull OperationClientMessage message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        WebSocket webSocket = this.webSocket.getAndSet(null);
        if (webSocket != null) {
            webSocket.close(1001, this.serializeToJson(message));
        }
        this.release();
    }

    @Override
    public void send(@NotNull OperationClientMessage message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        WebSocket webSocket = this.webSocket.get();
        if (webSocket == null) {
            WebSocketSubscriptionTransport webSocketSubscriptionTransport = this;
            boolean bl = false;
            boolean bl2 = false;
            WebSocketSubscriptionTransport $this$send_u24lambda_u2d1 = webSocketSubscriptionTransport;
            boolean bl3 = false;
            $this$send_u24lambda_u2d1.callback.onFailure(new IllegalStateException("Send attempted on closed connection"));
            return;
        }
        WebSocket socket = webSocket;
        socket.send(this.serializeToJson(message));
    }

    public final void onOpen$apollo_runtime() {
        this.callback.onConnected();
    }

    public final void onMessage$apollo_runtime(@Nullable OperationServerMessage message) {
        this.callback.onMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFailure$apollo_runtime(@Nullable Throwable t) {
        try {
            this.callback.onFailure(t);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onClosed$apollo_runtime() {
        try {
            this.callback.onClosed();
        }
        finally {
            this.release();
        }
    }

    private final void release() {
        WebSocketListener webSocketListener = this.webSocketListener.getAndSet(null);
        if (webSocketListener != null) {
            webSocketListener.release();
        }
        this.webSocket.set(null);
    }

    private final String serializeToJson(OperationClientMessage $this$serializeToJson) {
        Buffer buffer = new Buffer();
        this.serializer.writeClientMessage($this$serializeToJson, buffer);
        return buffer.readUtf8();
    }

    @JvmOverloads
    public WebSocketSubscriptionTransport(@NotNull Request webSocketRequest, @NotNull WebSocket.Factory webSocketConnectionFactory, @NotNull SubscriptionTransport.Callback callback) {
        Intrinsics.checkParameterIsNotNull(webSocketRequest, "webSocketRequest");
        Intrinsics.checkParameterIsNotNull(webSocketConnectionFactory, "webSocketConnectionFactory");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        this(webSocketRequest, webSocketConnectionFactory, callback, null, 8, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0019\u001a\u00020\tR\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lxsquash4gitlab/com/apollographql/apollo/subscription/WebSocketSubscriptionTransport$WebSocketListener;", "Lxsquash4gitlab/okhttp3/WebSocketListener;", "delegate", "Lxsquash4gitlab/com/apollographql/apollo/subscription/WebSocketSubscriptionTransport;", "(Lcom/apollographql/apollo/subscription/WebSocketSubscriptionTransport;)V", "delegateRef", "Ljava/lang/ref/WeakReference;", "xsquash4gitlab.kotlin.jvm.PlatformType", "onClosed", "", "webSocket", "Lxsquash4gitlab/okhttp3/WebSocket;", "code", "", "reason", "", "onClosing", "onFailure", "t", "", "response", "Lxsquash4gitlab/okhttp3/Response;", "onMessage", "text", "onOpen", "release", "apollo-runtime"})
    public static final class WebSocketListener
    extends xsquash4gitlab.okhttp3.WebSocketListener {
        @NotNull
        private final WeakReference<WebSocketSubscriptionTransport> delegateRef;

        public WebSocketListener(@NotNull WebSocketSubscriptionTransport delegate) {
            Intrinsics.checkParameterIsNotNull(delegate, "delegate");
            this.delegateRef = new WeakReference<WebSocketSubscriptionTransport>(delegate);
        }

        @Override
        public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
            Intrinsics.checkParameterIsNotNull(webSocket, "webSocket");
            Intrinsics.checkParameterIsNotNull(response, "response");
            WebSocketSubscriptionTransport webSocketSubscriptionTransport = (WebSocketSubscriptionTransport)this.delegateRef.get();
            if (webSocketSubscriptionTransport != null) {
                webSocketSubscriptionTransport.onOpen$apollo_runtime();
            }
        }

        @Override
        public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
            WebSocketSubscriptionTransport webSocketSubscriptionTransport;
            Intrinsics.checkParameterIsNotNull(webSocket, "webSocket");
            Intrinsics.checkParameterIsNotNull(text, "text");
            WebSocketSubscriptionTransport webSocketSubscriptionTransport2 = (WebSocketSubscriptionTransport)this.delegateRef.get();
            if (webSocketSubscriptionTransport2 == null) {
                return;
            }
            WebSocketSubscriptionTransport delegate = webSocketSubscriptionTransport = webSocketSubscriptionTransport2;
            delegate.onMessage$apollo_runtime(delegate.serializer.readServerMessage(new Buffer().writeUtf8(text)));
        }

        @Override
        public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
            Intrinsics.checkParameterIsNotNull(webSocket, "webSocket");
            Intrinsics.checkParameterIsNotNull(t, "t");
            WebSocketSubscriptionTransport webSocketSubscriptionTransport = (WebSocketSubscriptionTransport)this.delegateRef.get();
            if (webSocketSubscriptionTransport != null) {
                webSocketSubscriptionTransport.onFailure$apollo_runtime(t);
            }
        }

        @Override
        public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
            Intrinsics.checkParameterIsNotNull(webSocket, "webSocket");
            Intrinsics.checkParameterIsNotNull(reason, "reason");
            WebSocketSubscriptionTransport webSocketSubscriptionTransport = (WebSocketSubscriptionTransport)this.delegateRef.get();
            if (webSocketSubscriptionTransport != null) {
                webSocketSubscriptionTransport.onClosed$apollo_runtime();
            }
        }

        @Override
        public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
            Intrinsics.checkParameterIsNotNull(webSocket, "webSocket");
            Intrinsics.checkParameterIsNotNull(reason, "reason");
            WebSocketSubscriptionTransport webSocketSubscriptionTransport = (WebSocketSubscriptionTransport)this.delegateRef.get();
            if (webSocketSubscriptionTransport != null) {
                webSocketSubscriptionTransport.onClosed$apollo_runtime();
            }
        }

        public final void release() {
            this.delegateRef.clear();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lxsquash4gitlab/com/apollographql/apollo/subscription/WebSocketSubscriptionTransport$Factory;", "Lxsquash4gitlab/com/apollographql/apollo/subscription/SubscriptionTransport$Factory;", "webSocketUrl", "", "webSocketConnectionFactory", "Lxsquash4gitlab/okhttp3/WebSocket$Factory;", "serializer", "Lxsquash4gitlab/com/apollographql/apollo/subscription/OperationMessageSerializer;", "(Ljava/lang/String;Lokhttp3/WebSocket$Factory;Lcom/apollographql/apollo/subscription/OperationMessageSerializer;)V", "webSocketRequest", "Lxsquash4gitlab/okhttp3/Request;", "create", "Lxsquash4gitlab/com/apollographql/apollo/subscription/SubscriptionTransport;", "callback", "Lxsquash4gitlab/com/apollographql/apollo/subscription/SubscriptionTransport$Callback;", "apollo-runtime"})
    public static final class Factory
    implements SubscriptionTransport.Factory {
        @NotNull
        private final WebSocket.Factory webSocketConnectionFactory;
        @NotNull
        private final OperationMessageSerializer serializer;
        @NotNull
        private final Request webSocketRequest;

        @JvmOverloads
        public Factory(@NotNull String webSocketUrl, @NotNull WebSocket.Factory webSocketConnectionFactory, @NotNull OperationMessageSerializer serializer) {
            Intrinsics.checkParameterIsNotNull(webSocketUrl, "webSocketUrl");
            Intrinsics.checkParameterIsNotNull(webSocketConnectionFactory, "webSocketConnectionFactory");
            Intrinsics.checkParameterIsNotNull(serializer, "serializer");
            this.webSocketConnectionFactory = webSocketConnectionFactory;
            this.serializer = serializer;
            Request request = new Request.Builder().url(webSocketUrl).addHeader("Sec-WebSocket-Protocol", "graphql-ws").addHeader("Cookie", "").build();
            Intrinsics.checkExpressionValueIsNotNull(request, "Builder()\n        .url(w\u2026ie\", \"\")\n        .build()");
            this.webSocketRequest = request;
        }

        public /* synthetic */ Factory(String string, WebSocket.Factory factory2, OperationMessageSerializer operationMessageSerializer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                operationMessageSerializer = ApolloOperationMessageSerializer.INSTANCE;
            }
            this(string, factory2, operationMessageSerializer);
        }

        @Override
        @NotNull
        public SubscriptionTransport create(@NotNull SubscriptionTransport.Callback callback) {
            Intrinsics.checkParameterIsNotNull(callback, "callback");
            return new WebSocketSubscriptionTransport(this.webSocketRequest, this.webSocketConnectionFactory, callback, this.serializer);
        }

        @JvmOverloads
        public Factory(@NotNull String webSocketUrl, @NotNull WebSocket.Factory webSocketConnectionFactory) {
            Intrinsics.checkParameterIsNotNull(webSocketUrl, "webSocketUrl");
            Intrinsics.checkParameterIsNotNull(webSocketConnectionFactory, "webSocketConnectionFactory");
            this(webSocketUrl, webSocketConnectionFactory, null, 4, null);
        }
    }
}

