/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.PagingAdapter;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabNote;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.AbstractGitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.CreateDiscussionNoteMutation;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetIssueNotesQuery;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

public class GitLabNoteClient
extends AbstractGitLabClient {
    public GitLabNoteClient(GitLabClient baseClient) {
        super(baseClient);
    }

    public GitLabClient.Page<List<GitLabNote>> getIssueNotesPage(String issueGlobalId, String startCursor) {
        GetIssueNotesQuery.Builder queryBuilder = GetIssueNotesQuery.builder();
        queryBuilder.id(issueGlobalId);
        PagingAdapter.GetIssueNotesPagingAdapter pagingAdapter = new PagingAdapter.GetIssueNotesPagingAdapter(queryBuilder);
        return this.gitLabClient.getSinglePage(100, pagingAdapter, (res, topLevelErrors) -> Optional.ofNullable(res).map(GetIssueNotesQuery.Data::issue).map(GetIssueNotesQuery.Issue::notes).map(GetIssueNotesQuery.Notes::nodes).map(nodes -> nodes.stream().map(this::asNote).collect(Collectors.toList())).orElse(Collections.emptyList()), startCursor);
    }

    private GitLabNote asNote(GetIssueNotesQuery.Node node) {
        return new GitLabNote(node.id().toString(), node.url(), node.body(), new GitLabNote.UserPermissions(node.userPermissions().adminNote()), Optional.ofNullable(node.discussion()).map(GetIssueNotesQuery.Discussion::id).map(String::valueOf).orElse(null));
    }

    public void createDiscussionNote(String issueId, String discussionId, String noteBody) {
        CreateDiscussionNoteMutation.Builder mutationBuilder = CreateDiscussionNoteMutation.builder();
        mutationBuilder.discussionId(discussionId);
        mutationBuilder.body(noteBody);
        mutationBuilder.id(issueId);
        this.gitLabClient.executeAndConvert(mutationBuilder.build(), (res, topLevelErrors) -> Optional.ofNullable(res).map(CreateDiscussionNoteMutation.Data::createNote).map(CreateDiscussionNoteMutation.CreateNote::note).map(this::asDiscussionNote).orElse(null));
    }

    private GitLabNote asDiscussionNote(@NotNull CreateDiscussionNoteMutation.Note note) {
        return new GitLabNote(note.id().toString(), note.url(), null, null, null);
    }
}

