/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.LicenseTemplate;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class LicenseTemplatesApi
extends AbstractApi {
    public LicenseTemplatesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<LicenseTemplate> getLicenseTemplates() throws GitLabApiException {
        return this.getLicenseTemplates(false, this.getDefaultPerPage()).all();
    }

    public Stream<LicenseTemplate> getLicenseTemplatesStream() throws GitLabApiException {
        return this.getLicenseTemplates(false, this.getDefaultPerPage()).stream();
    }

    public Pager<LicenseTemplate> getLicenseTemplates(int itemsPerPage) throws GitLabApiException {
        return this.getLicenseTemplates(false, itemsPerPage);
    }

    public List<LicenseTemplate> getPopularLicenseTemplates() throws GitLabApiException {
        return this.getLicenseTemplates(true, this.getDefaultPerPage()).all();
    }

    public Stream<LicenseTemplate> getPopularLicenseTemplatesStream() throws GitLabApiException {
        return this.getLicenseTemplates(true, this.getDefaultPerPage()).stream();
    }

    public Pager<LicenseTemplate> getLicenseTemplates(Boolean popular, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("popular", popular);
        return new Pager<LicenseTemplate>(this, LicenseTemplate.class, itemsPerPage, formData.asMap(), "templates", "licenses");
    }

    public LicenseTemplate getLicenseTemplate(String key) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "licenses", key);
        return response.readEntity(LicenseTemplate.class);
    }

    public Optional<LicenseTemplate> getOptionalLicenseTemplate(String key) {
        try {
            return Optional.ofNullable(this.getLicenseTemplate(key));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }
}

