/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.AuditEvent;
import gitlabbt.org.gitlab4j.models.utils.ISO8601;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;

public class AuditEventApi
extends AbstractApi {
    public AuditEventApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<AuditEvent> getAuditEvents(Date created_after, Date created_before, String entityType, Long entityId) throws GitLabApiException {
        return this.getAuditEvents(created_after, created_before, entityType, entityId, this.getDefaultPerPage()).all();
    }

    public Pager<AuditEvent> getAuditEvents(Date created_after, Date created_before, String entityType, Long entityId, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("created_before", ISO8601.toString(created_before, false)).withParam("created_after", ISO8601.toString(created_after, false)).withParam("entity_type", entityType).withParam("entity_id", entityId);
        return new Pager<AuditEvent>(this, AuditEvent.class, itemsPerPage, form.asMap(), "audit_events");
    }

    public Stream<AuditEvent> getAuditEventsStream(Date created_after, Date created_before, String entityType, Long entityId) throws GitLabApiException {
        return this.getAuditEvents(created_after, created_before, entityType, entityId, this.getDefaultPerPage()).stream();
    }

    public AuditEvent getAuditEvent(Long auditEventId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "audit_events", auditEventId);
        return response.readEntity(AuditEvent.class);
    }
}

