/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.service;

import gitlabbt.org.gitlab4j.api.GitLabApiException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.EntityType;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.helper.EmojiStringHelper;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.GitLabApiWrapper;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.ScopedLabelHelper;
import org.squashtest.tm.plugin.bugtracker.gitlab.configuration.PersistedConfiguration;
import org.squashtest.tm.plugin.bugtracker.gitlab.dao.ConfigurationDao;
import org.squashtest.tm.plugin.bugtracker.gitlab.dto.AvailableLabelsDto;
import org.squashtest.tm.plugin.bugtracker.gitlab.dto.ConfigPageModelDto;
import org.squashtest.tm.plugin.bugtracker.gitlab.dto.GitLabProjectConfigurationDto;
import org.squashtest.tm.plugin.bugtracker.gitlab.dto.IssueMappingsDto;
import org.squashtest.tm.plugin.bugtracker.gitlab.exceptions.BadBugTrackerConfigurationException;
import org.squashtest.tm.service.internal.display.dto.BugTrackerDto;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.servers.CredentialsProvider;

@Service(value="squash.tm.plugin.bugtracker.gitlab.ConfigurationService")
@Transactional
public class ConfigurationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationService.class);
    public static final String CONFIGURATION_ERROR_MESSAGE = "Could not load configuration for project ";
    private final ConfigurationDao dao;
    private final GenericProjectManagerService projectManager;
    private final CredentialsProvider credentialsProvider;
    private final BugTrackerDao bugTrackerDao;

    public ConfigurationService(ConfigurationDao dao, GenericProjectManagerService projectManager, CredentialsProvider credentialsProvider, BugTrackerDao bugTrackerDao) {
        this.dao = dao;
        this.projectManager = projectManager;
        this.credentialsProvider = credentialsProvider;
        this.bugTrackerDao = bugTrackerDao;
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public ConfigPageModelDto getConfigurationPageData(Long projectId) {
        boolean hasGitLabBugTracker;
        GenericProject project = this.projectManager.findById(projectId.longValue());
        BugTracker bugTracker = project.getBugTracker();
        boolean hasBugTrackerBinding = bugTracker != null;
        boolean bl = hasGitLabBugTracker = hasBugTrackerBinding && bugTracker.getKind().equals("gitlab.bugtracker");
        if (!hasBugTrackerBinding || !hasGitLabBugTracker) {
            throw new BadBugTrackerConfigurationException();
        }
        BugTrackerDto bugTrackerDto = BugTrackerDto.from((BugTracker)bugTracker);
        Optional<Credentials> credentials = this.getCredentials(bugTracker.getId());
        Map<String, GitLabProjectConfigurationDto> configurationByProject = this.getConfigurationByGitLabProject(project, credentials);
        return new ConfigPageModelDto(projectId, configurationByProject, credentials.isEmpty(), bugTrackerDto, null, this.getDisplayState(projectId));
    }

    private Map<String, GitLabProjectConfigurationDto> getConfigurationByGitLabProject(GenericProject tmProject, Optional<Credentials> credentials) {
        List projectNames = tmProject.getBugtrackerProjectNames();
        PersistedConfiguration persistedConfiguration = this.dao.loadOrGetDefaultConfiguration(tmProject.getId());
        HashMap<String, GitLabProjectConfigurationDto> configurationByProject = new HashMap<String, GitLabProjectConfigurationDto>();
        for (String projectName : projectNames) {
            configurationByProject.put(projectName, this.getGitLabProjectConfiguration(tmProject, credentials, projectName, persistedConfiguration));
        }
        for (String projectName : persistedConfiguration.getMappings().keySet()) {
            configurationByProject.putIfAbsent(projectName, this.getDetachedGitLabProjectConfiguration(projectName, persistedConfiguration));
        }
        return configurationByProject;
    }

    private GitLabProjectConfigurationDto getDetachedGitLabProjectConfiguration(String projectName, PersistedConfiguration persistedConfiguration) {
        return new GitLabProjectConfigurationDto(projectName, this.getConfiguredMappings(persistedConfiguration).get(projectName), persistedConfiguration.getCustomDescriptionTemplates().getOrDefault(projectName, ""), false, true, null);
    }

    private GitLabProjectConfigurationDto getGitLabProjectConfiguration(GenericProject tmProject, Optional<Credentials> credentials, String projectName, PersistedConfiguration persistedConfiguration) {
        boolean isProjectAvailable = false;
        AvailableLabelsDto availableLabels = null;
        if (credentials.isPresent()) {
            try (GitLabApiWrapper gitLabApi = new GitLabApiWrapper(tmProject.getBugTracker(), credentials.get());){
                availableLabels = this.findAvailableLabels(gitLabApi, projectName);
                isProjectAvailable = true;
            }
            catch (GitLabApiException | BugTrackerRemoteException ex) {
                LOGGER.trace("Could not load available labels for project {}", new Object[]{projectName, ex});
            }
        }
        IssueMappingsDto projectMappings = this.getConfiguredMappings(persistedConfiguration).get(projectName);
        String customDescriptionTemplate = persistedConfiguration.getCustomDescriptionTemplates().getOrDefault(projectName, "");
        return new GitLabProjectConfigurationDto(projectName, projectMappings, customDescriptionTemplate, isProjectAvailable, false, availableLabels);
    }

    private boolean getDisplayState(Long projectId) {
        PersistedConfiguration persistedConfiguration = this.dao.loadOrGetDefaultConfiguration(projectId);
        return persistedConfiguration.isDisplayState();
    }

    public Map<String, IssueMappingsDto> getConfiguredMappings(PersistedConfiguration persistedConfiguration) {
        return persistedConfiguration.getMappings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.asIssueMappingsConfiguration((PersistedConfiguration.Mappings)e.getValue())));
    }

    private IssueMappingsDto asIssueMappingsConfiguration(PersistedConfiguration.Mappings value) {
        return new IssueMappingsDto(value.getPropertyScopes(), value.getPropertyLabels(), value.getStatusScopes(), value.getStatusLabels());
    }

    private AvailableLabelsDto findAvailableLabels(GitLabApiWrapper gitLabApi, String projectPath) throws GitLabApiException {
        HashSet scopes = new HashSet();
        HashSet labels = new HashSet();
        gitLabApi.getProjectLabels(projectPath).forEach(label -> {
            if (ScopedLabelHelper.isScopedLabel(label.getName())) {
                scopes.add(ScopedLabelHelper.extractLabelScope(label.getName()));
            } else {
                labels.add(label.getName());
            }
        });
        return new AvailableLabelsDto(scopes.stream().sorted().collect(Collectors.toList()), labels.stream().sorted().collect(Collectors.toList()));
    }

    private Optional<Credentials> getCredentials(Long serverId) {
        BugTracker server = (BugTracker)this.bugTrackerDao.getReferenceById((Object)serverId);
        Optional appLevelCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)server);
        Optional userCredentials = this.credentialsProvider.getCurrentUserCredentials((ThirdPartyServer)server);
        AuthenticationPolicy policy = server.getAuthenticationPolicy();
        if (policy.equals((Object)AuthenticationPolicy.APP_LEVEL)) {
            return appLevelCredentials;
        }
        return appLevelCredentials.isPresent() ? appLevelCredentials : userCredentials;
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void setPriorityMappings(Long projectId, String remoteProjectPath, List<String> scopes, List<String> labels) {
        try {
            PersistedConfiguration configuration = this.dao.loadOrGetDefaultConfiguration(projectId);
            Map<String, PersistedConfiguration.Mappings> mappingsByProject = configuration.getMappings();
            labels = EmojiStringHelper.findAndEncodeStringsWithEmoji(labels);
            PersistedConfiguration.Mappings updatedMappings = mappingsByProject.getOrDefault(remoteProjectPath, PersistedConfiguration.Mappings.empty()).withPropertyLabels(labels).withPropertyScopes(scopes);
            if (PersistedConfiguration.Mappings.isEmpty(updatedMappings)) {
                mappingsByProject.remove(remoteProjectPath);
            } else {
                mappingsByProject.put(remoteProjectPath, updatedMappings);
            }
            this.dao.saveConfiguration(projectId, configuration.withMappings(mappingsByProject));
        }
        catch (IOException ex) {
            throw new BugTrackerLocalException(CONFIGURATION_ERROR_MESSAGE + projectId, (Throwable)ex);
        }
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void setStatusMappings(Long projectId, String remoteProjectPath, List<String> scopes, List<String> labels) {
        try {
            PersistedConfiguration configuration = this.dao.loadOrGetDefaultConfiguration(projectId);
            Map<String, PersistedConfiguration.Mappings> mappingsByProject = configuration.getMappings();
            labels = EmojiStringHelper.findAndEncodeStringsWithEmoji(labels);
            PersistedConfiguration.Mappings updatedMappings = mappingsByProject.getOrDefault(remoteProjectPath, PersistedConfiguration.Mappings.empty()).withStatusLabels(labels).withStatusScopes(scopes);
            if (PersistedConfiguration.Mappings.isEmpty(updatedMappings)) {
                mappingsByProject.remove(remoteProjectPath);
            } else {
                mappingsByProject.put(remoteProjectPath, updatedMappings);
            }
            this.dao.saveConfiguration(projectId, configuration.withMappings(mappingsByProject));
        }
        catch (IOException ex) {
            throw new BugTrackerLocalException(CONFIGURATION_ERROR_MESSAGE + projectId, (Throwable)ex);
        }
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void removeProjectMappings(Long projectId, String remoteProjectPath) {
        try {
            PersistedConfiguration configuration = this.dao.loadOrGetDefaultConfiguration(projectId);
            configuration.getMappings().remove(remoteProjectPath);
            configuration.getCustomDescriptionTemplates().remove(remoteProjectPath);
            this.dao.saveConfiguration(projectId, configuration);
        }
        catch (IOException ex) {
            throw new BugTrackerLocalException(CONFIGURATION_ERROR_MESSAGE + projectId, (Throwable)ex);
        }
    }

    public boolean hasConfiguration(EntityReference entityReference) {
        if (entityReference == null || !EntityType.PROJECT.equals((Object)entityReference.getType())) {
            return false;
        }
        PersistedConfiguration configuration = this.dao.loadOrGetDefaultConfiguration(entityReference.getId());
        return !this.getConfiguredMappings(configuration).isEmpty() || !configuration.getCustomDescriptionTemplates().isEmpty();
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateDisplayState(long projectId, boolean newValue) {
        this.dao.updateDisplayState(projectId, newValue);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void setCustomDescriptionTemplate(Long projectId, String projectPath, String customDescriptionTemplate) {
        try {
            PersistedConfiguration configuration = this.dao.loadOrGetDefaultConfiguration(projectId);
            Map<String, String> descriptionByProject = configuration.getCustomDescriptionTemplates();
            if (StringUtils.isEmpty((CharSequence)customDescriptionTemplate)) {
                descriptionByProject.remove(projectPath);
            } else {
                descriptionByProject.put(projectPath, customDescriptionTemplate);
            }
            this.dao.saveConfiguration(projectId, configuration.withCustomDescriptionTemplates(descriptionByProject));
        }
        catch (IOException ex) {
            throw new BugTrackerLocalException(CONFIGURATION_ERROR_MESSAGE + projectId, (Throwable)ex);
        }
    }

    public String getCustomDescriptionTemplate(Long projectId, String projectPath) {
        PersistedConfiguration configuration = this.dao.loadOrGetDefaultConfiguration(projectId);
        return configuration.getCustomDescriptionTemplates().getOrDefault(projectPath, "");
    }
}

