/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.caching;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.BugTrackerAndPath;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.CachedValues;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.CompositeCacheKey;

public class ValueCacheQueue {
    private final List<BugTrackerAndPath> bugTrackerAndPaths = new ArrayList<BugTrackerAndPath>();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.bugTrackerAndPaths.size();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(BugTrackerAndPath bugTrackerAndPath) {
        Object object = this.lock;
        synchronized (object) {
            return this.bugTrackerAndPaths.contains(bugTrackerAndPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(BugTrackerAndPath bugTrackerAndPath, Map<CompositeCacheKey, CachedValues> cacheMap) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bugTrackerAndPaths.contains(bugTrackerAndPath)) {
                return;
            }
            this.bugTrackerAndPaths.add(bugTrackerAndPath);
            this.orderByPriority(cacheMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BugTrackerAndPath poll() {
        Object object = this.lock;
        synchronized (object) {
            if (this.bugTrackerAndPaths.isEmpty()) {
                return null;
            }
            return this.bugTrackerAndPaths.remove(0);
        }
    }

    private void orderByPriority(Map<CompositeCacheKey, CachedValues> cacheMap) {
        this.bugTrackerAndPaths.sort(Comparator.comparingInt(o -> {
            CachedValues cachedValues = (CachedValues)cacheMap.get(new CompositeCacheKey(o.bugTracker().getId(), o.path()));
            if (cachedValues == null) {
                return 1;
            }
            return cachedValues.hasCacheError() ? 0 : 2;
        }));
    }
}

