/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.caching;

import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.models.Epic;
import gitlabbt.org.gitlab4j.api.models.Project;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.BugTrackerAndPath;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.CachedValues;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.CompositeCacheKey;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.ValueCacheManager;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.GitLabApiWrapper;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

public class ValueCacheWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueCacheWorker.class);
    private static final String FETCH_OPERATION = "Fetching";
    private static final String CACHE_OPERATION = "Caching";
    private static final String BUGTRACKER_ID = "bugtrackerId";
    private static final String PROJECT_PATH = "projectPath";
    private final ValueCacheManager manager;
    private final int id;
    private final Object lock = new Object();

    ValueCacheWorker(ValueCacheManager valueCacheManager, int id) {
        this.manager = valueCacheManager;
        this.id = id;
    }

    public void start() {
        this.manager.getTaskScheduler().schedule(this::processInSynchronizedBlock, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInSynchronizedBlock() {
        Object object = this.lock;
        synchronized (object) {
            this.doProcess();
        }
    }

    private void doProcess() {
        while (!this.manager.getQueue().isEmpty()) {
            BugTrackerAndPath bugTrackerAndPath = this.manager.getQueue().poll();
            BugTracker bugTracker = bugTrackerAndPath.bugTracker();
            String projectPath = bugTrackerAndPath.path();
            Long bugtrackerId = bugTracker.getId();
            Credentials credentials = this.findCredentials(bugtrackerId, bugTracker);
            if (credentials == null) {
                LOGGER.warn("[Worker #{}] No credentials found for bugtracker {}. Cache cannot be used", (Object)this.id, (Object)bugtrackerId);
                continue;
            }
            this.updateCachedValues(bugTracker, credentials, projectPath);
        }
    }

    private Credentials findCredentials(Long bugtrackerId, BugTracker bugTracker) {
        StoredCredentialsManager storedCredentialsManager = this.manager.getStoredCredentialsManager();
        ManageableCredentials manageableCredentials = storedCredentialsManager.findReportingCacheCredentials(bugtrackerId.longValue());
        if (manageableCredentials == null) {
            return null;
        }
        return manageableCredentials.build(storedCredentialsManager, (ThirdPartyServer)bugTracker, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateCachedValues(BugTracker bugTracker, Credentials credentials, String path) {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        if (isDebugEnabled) {
            MDC.put((String)PROJECT_PATH, (String)path);
            MDC.put((String)BUGTRACKER_ID, (String)String.valueOf(bugTracker.getId()));
        }
        LOGGER.trace("[Worker #{}] Updating cache for project {} and bug tracker {}", new Object[]{this.id, path, bugTracker.getId()});
        CompositeCacheKey key = new CompositeCacheKey(bugTracker.getId(), path);
        long startTime = isDebugEnabled ? System.nanoTime() : 0L;
        boolean success = false;
        try {
            try (GitLabApiWrapper gitLabApiWrapper = this.createGitLabApiWrapper(bugTracker, credentials);){
                Project project = gitLabApiWrapper.getProject(path);
                Long bugTrackerId = bugTracker.getId();
                CachedValues cachedValues = CachedValues.of(this.timeStore("Users", () -> this.manager.getUserPool().replaceWithReferences(bugTrackerId, this.timeFetch("ProjectUsers", () -> gitLabApiWrapper.getProjectUsers(path)))), this.timeStore("Labels", () -> this.manager.getLabelPool().replaceWithReferences(bugTrackerId, this.timeFetch("ProjectLabels", () -> gitLabApiWrapper.getProjectLabels(path)))), this.timeStore("Milestones", () -> this.manager.getMilestonePool().replaceWithReferences(bugTrackerId, this.timeFetch("ProjectMilestones", () -> gitLabApiWrapper.getProjectMilestones(path)))), this.timeStore("Epics", () -> this.manager.getEpicPool().replaceWithReferences(bugTrackerId, this.timeFetch("ProjectEpics", () -> this.findEpics(gitLabApiWrapper, project)))));
                this.manager.cacheMap.put(key, cachedValues);
                success = true;
                LOGGER.trace("[Worker #{}] Finished cache update for project {} and bug tracker {}", new Object[]{this.id, path, bugTracker.getId()});
            }
            if (!isDebugEnabled) return;
        }
        catch (GitLabApiException e) {
            try {
                if (this.manager.cacheMap.containsKey(key)) {
                    this.manager.cacheMap.put(key, this.manager.cacheMap.get(key).withLastUpdateError());
                } else {
                    this.manager.cacheMap.put(key, CachedValues.error());
                }
                if (e.getHttpStatus() == 429) {
                    LOGGER.info("[Worker #{}] Usage limit was hit for project {} and bug tracker {}. Cache update will be retried in {} minutes.", new Object[]{this.id, path, bugTracker.getId(), 5L, e});
                    this.manager.retryLater(bugTracker, path);
                } else {
                    Object message = "[Worker #%s] Error while updating cache for project %s and bug tracker %s.".formatted(this.id, path, bugTracker.getId());
                    if (this.manager.cacheMap.get(key).hasCachedValues()) {
                        message = (String)message + " The previously cached will be used until the next update.";
                    }
                    LOGGER.error((String)message, (Throwable)e);
                }
                if (!isDebugEnabled) return;
            }
            catch (Throwable throwable) {
                if (!isDebugEnabled) throw throwable;
                MDC.remove((String)PROJECT_PATH);
                MDC.remove((String)BUGTRACKER_ID);
                double durationMs = (double)(System.nanoTime() - startTime) / 1000000.0;
                String durationStr = String.format("%.2f", durationMs);
                LOGGER.debug("[Worker #{}] {} for project {} (bugtracker {}) in {}ms", new Object[]{this.id, success ? "Cache updated" : "Failed to update cache", path, bugTracker.getId(), durationStr});
                throw throwable;
            }
            MDC.remove((String)PROJECT_PATH);
            MDC.remove((String)BUGTRACKER_ID);
            double durationMs = (double)(System.nanoTime() - startTime) / 1000000.0;
            String durationStr = String.format("%.2f", durationMs);
            LOGGER.debug("[Worker #{}] {} for project {} (bugtracker {}) in {}ms", new Object[]{this.id, success ? "Cache updated" : "Failed to update cache", path, bugTracker.getId(), durationStr});
            return;
        }
        MDC.remove((String)PROJECT_PATH);
        MDC.remove((String)BUGTRACKER_ID);
        double durationMs = (double)(System.nanoTime() - startTime) / 1000000.0;
        String durationStr = String.format("%.2f", durationMs);
        LOGGER.debug("[Worker #{}] {} for project {} (bugtracker {}) in {}ms", new Object[]{this.id, success ? "Cache updated" : "Failed to update cache", path, bugTracker.getId(), durationStr});
        return;
    }

    private <T> T timeFetch(String label, CheckedSupplier<T, GitLabApiException> supplier) throws GitLabApiException {
        return this.timeOperation(FETCH_OPERATION, label, supplier);
    }

    private <T> T timeStore(String label, CheckedSupplier<T, GitLabApiException> supplier) throws GitLabApiException {
        return this.timeOperation(CACHE_OPERATION, label, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Exception> T timeOperation(String operation, String label, CheckedSupplier<T, E> supplier) throws E {
        long ms;
        T t;
        if (!LOGGER.isDebugEnabled()) {
            return supplier.get();
        }
        long start = System.nanoTime();
        try {
            t = supplier.get();
            ms = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        }
        catch (Throwable throwable) {
            long ms2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            LOGGER.debug(this.formatOperationTimeLogMessage("{} {} took {} ms"), new Object[]{operation, label, ms2});
            throw throwable;
        }
        LOGGER.debug(this.formatOperationTimeLogMessage("{} {} took {} ms"), new Object[]{operation, label, ms});
        return t;
    }

    private List<Epic> findEpics(GitLabApiWrapper gitLabApiWrapper, Project project) {
        try {
            return gitLabApiWrapper.getEpics(project);
        }
        catch (GitLabApiException e) {
            LOGGER.trace("Error while fetching epics for project " + project.getPathWithNamespace(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private GitLabApiWrapper createGitLabApiWrapper(BugTracker bugTracker, Credentials credentials) {
        return new GitLabApiWrapper(bugTracker, credentials);
    }

    private String formatOperationTimeLogMessage(String message) {
        return String.format("[Worker #%s] project %s (bugtracker %s) - %s", this.id, MDC.get((String)PROJECT_PATH), MDC.get((String)BUGTRACKER_ID), message);
    }

    @FunctionalInterface
    private static interface CheckedSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

