/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.glassfish.jersey.message.internal;

import gitlabbt.org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import gitlabbt.org.glassfish.jersey.message.internal.ReaderWriter;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Singleton
@Consumes(value={"text/plain"})
@Produces(value={"text/plain"})
final class EnumMessageProvider
extends AbstractMessageReaderWriterProvider<Enum> {
    EnumMessageProvider() {
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isEnum();
    }

    @Override
    public Enum readFrom(Class<Enum> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String value = ReaderWriter.readFromAsString(entityStream, mediaType);
        return Enum.valueOf(type, value);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isEnum();
    }

    @Override
    public void writeTo(Enum anEnum, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ReaderWriter.writeToAsString(anEnum.name(), entityStream, mediaType);
    }
}

