/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.glassfish.jersey.client;

import gitlabbt.org.glassfish.jersey.client.ClientAsyncExecutor;
import gitlabbt.org.glassfish.jersey.client.internal.LocalizationMessages;
import gitlabbt.org.glassfish.jersey.internal.util.collection.LazyValue;
import gitlabbt.org.glassfish.jersey.internal.util.collection.Value;
import gitlabbt.org.glassfish.jersey.internal.util.collection.Values;
import gitlabbt.org.glassfish.jersey.spi.ThreadPoolExecutorProvider;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import java.util.logging.Logger;

@ClientAsyncExecutor
class DefaultClientAsyncExecutorProvider
extends ThreadPoolExecutorProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultClientAsyncExecutorProvider.class.getName());
    private final LazyValue<Integer> asyncThreadPoolSize;

    @Inject
    public DefaultClientAsyncExecutorProvider(final @Named(value="ClientAsyncThreadPoolSize") int poolSize, @Context Configuration configuration) {
        super("jersey-client-async-executor", configuration);
        this.asyncThreadPoolSize = Values.lazy(new Value<Integer>(){

            @Override
            public Integer get() {
                if (poolSize <= 0) {
                    LOGGER.config(LocalizationMessages.IGNORED_ASYNC_THREADPOOL_SIZE(poolSize));
                    return Integer.MAX_VALUE;
                }
                LOGGER.config(LocalizationMessages.USING_FIXED_ASYNC_THREADPOOL(poolSize));
                return poolSize;
            }
        });
    }

    @Override
    protected int getMaximumPoolSize() {
        return (Integer)this.asyncThreadPoolSize.get();
    }

    @Override
    protected int getCorePoolSize() {
        Integer maximumPoolSize = this.getMaximumPoolSize();
        if (maximumPoolSize != Integer.MAX_VALUE) {
            return maximumPoolSize;
        }
        return 0;
    }
}

