/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.configuration;

import gitlabbt.com.fasterxml.jackson.core.type.TypeReference;
import gitlabbt.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class PersistedConfiguration {
    private static final String MAPPINGS_KEY = "mappings";
    private static final String CUSTOM_DESCRIPTION_TEMPLATES_KEY = "customDescriptionTemplates";
    public static final String DISPLAY_STATE_KEY = "gitLabDisplayState";
    private final Map<String, Mappings> mappingsByProjectPath;
    private final Map<String, String> customDescriptionTemplates;
    private boolean displayState;

    public PersistedConfiguration(Map<String, Mappings> mappings, Map<String, String> customDescriptionTemplates, boolean displayState) {
        Objects.requireNonNull(mappings);
        Objects.requireNonNull(customDescriptionTemplates);
        this.mappingsByProjectPath = new HashMap<String, Mappings>(mappings);
        this.customDescriptionTemplates = new HashMap<String, String>(customDescriptionTemplates);
        this.displayState = displayState;
    }

    public static PersistedConfiguration withDefaultConfiguration() {
        return new PersistedConfiguration(new HashMap<String, Mappings>(), new HashMap<String, String>(), true);
    }

    public Map<String, Mappings> getMappings() {
        return this.mappingsByProjectPath;
    }

    public boolean isDisplayState() {
        return this.displayState;
    }

    public void setDisplayState(boolean displayState) {
        this.displayState = displayState;
    }

    public Map<String, String> getCustomDescriptionTemplates() {
        return this.customDescriptionTemplates;
    }

    public Map<String, String> asRawMap() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String jsonMappings = mapper.writeValueAsString(this.mappingsByProjectPath);
        String jsonDescriptions = mapper.writeValueAsString(this.customDescriptionTemplates);
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(MAPPINGS_KEY, jsonMappings);
        finalMap.put(CUSTOM_DESCRIPTION_TEMPLATES_KEY, jsonDescriptions);
        finalMap.put(DISPLAY_STATE_KEY, String.valueOf(this.isDisplayState()));
        return finalMap;
    }

    public static PersistedConfiguration fromRawMap(Map<String, String> rawConfiguration) throws IOException {
        Map mappings = rawConfiguration.containsKey(MAPPINGS_KEY) ? (Map)new ObjectMapper().readValue(rawConfiguration.get(MAPPINGS_KEY), new TypeReference<HashMap<String, Mappings>>(){}) : new HashMap();
        Map descriptions = rawConfiguration.containsKey(CUSTOM_DESCRIPTION_TEMPLATES_KEY) ? (Map)new ObjectMapper().readValue(rawConfiguration.get(CUSTOM_DESCRIPTION_TEMPLATES_KEY), new TypeReference<HashMap<String, String>>(){}) : new HashMap();
        boolean displayState = rawConfiguration.containsKey(DISPLAY_STATE_KEY) ? new ObjectMapper().readValue(rawConfiguration.get(DISPLAY_STATE_KEY), Boolean.class) : true;
        return new PersistedConfiguration(mappings, descriptions, displayState);
    }

    public PersistedConfiguration withMappings(Map<String, Mappings> mappingsByProject) {
        return new PersistedConfiguration(mappingsByProject, this.customDescriptionTemplates, this.displayState);
    }

    public PersistedConfiguration withCustomDescriptionTemplates(Map<String, String> descriptionByProject) {
        return new PersistedConfiguration(this.mappingsByProjectPath, descriptionByProject, this.displayState);
    }

    public boolean isEmpty() {
        return this.mappingsByProjectPath.isEmpty() && this.customDescriptionTemplates.isEmpty();
    }

    public static final class Mappings {
        private final List<String> propertyScopes;
        private final List<String> propertyLabels;
        private final List<String> statusScopes;
        private final List<String> statusLabels;

        public Mappings() {
            this.propertyLabels = Collections.emptyList();
            this.propertyScopes = Collections.emptyList();
            this.statusLabels = Collections.emptyList();
            this.statusScopes = Collections.emptyList();
        }

        public Mappings(List<String> propertyScopes, List<String> propertyLabels, List<String> statusScopes, List<String> statusLabels) {
            this.propertyScopes = propertyScopes;
            this.propertyLabels = propertyLabels;
            this.statusScopes = statusScopes;
            this.statusLabels = statusLabels;
        }

        public static Mappings empty() {
            return new Mappings(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }

        public Mappings withPropertyScopes(List<String> propertyScopes) {
            return new Mappings(propertyScopes, this.propertyLabels, this.statusScopes, this.statusLabels);
        }

        public Mappings withPropertyLabels(List<String> propertyLabels) {
            return new Mappings(this.propertyScopes, propertyLabels, this.statusScopes, this.statusLabels);
        }

        public Mappings withStatusScopes(List<String> statusScopes) {
            return new Mappings(this.propertyScopes, this.propertyLabels, statusScopes, this.statusLabels);
        }

        public Mappings withStatusLabels(List<String> statusLabels) {
            return new Mappings(this.propertyScopes, this.propertyLabels, this.statusScopes, statusLabels);
        }

        public List<String> getPropertyScopes() {
            return this.propertyScopes;
        }

        public List<String> getPropertyLabels() {
            return this.propertyLabels;
        }

        public List<String> getStatusScopes() {
            return this.statusScopes;
        }

        public List<String> getStatusLabels() {
            return this.statusLabels;
        }

        public static boolean isEmpty(Mappings mappings) {
            return mappings.propertyLabels.isEmpty() && mappings.propertyScopes.isEmpty() && mappings.statusLabels.isEmpty() && mappings.statusScopes.isEmpty();
        }
    }
}

