/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.glassfish.jersey.message.internal;

import gitlabbt.org.glassfish.jersey.internal.LocalizationMessages;
import gitlabbt.org.glassfish.jersey.message.internal.HttpDateFormat;
import gitlabbt.org.glassfish.jersey.message.internal.HttpHeaderReader;
import gitlabbt.org.glassfish.jersey.message.internal.Utils;
import gitlabbt.org.glassfish.jersey.spi.HeaderDelegateProvider;
import jakarta.inject.Singleton;
import java.text.ParseException;
import java.util.Date;

@Singleton
public class DateProvider
implements HeaderDelegateProvider<Date> {
    @Override
    public boolean supports(Class<?> type) {
        return Date.class.isAssignableFrom(type);
    }

    @Override
    public String toString(Date header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.DATE_IS_NULL());
        return HttpDateFormat.getPreferredDateFormatter().format(header);
    }

    @Override
    public Date fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.DATE_IS_NULL());
        try {
            return HttpHeaderReader.readDate(header);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Error parsing date '" + header + "'", ex);
        }
    }
}

