/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.domain;

import gitlabbt.com.fasterxml.jackson.core.JsonProcessingException;
import gitlabbt.com.fasterxml.jackson.databind.ObjectMapper;
import gitlabbt.org.gitlab4j.api.models.Issue;
import java.io.IOException;
import java.util.Objects;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;

public class GitLabIssueKey {
    private Long id;
    private Long iid;
    private String projectPath;

    GitLabIssueKey() {
    }

    public GitLabIssueKey(Long id, Long iid, String projectPath) {
        this.id = id;
        this.iid = iid;
        this.projectPath = projectPath;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getIid() {
        return this.iid;
    }

    public void setIid(Long iid) {
        this.iid = iid;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitLabIssueKey that = (GitLabIssueKey)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toJsonString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new BugTrackerRemoteException((Throwable)e);
        }
    }

    public static GitLabIssueKey create(Issue issue, String projectPath) {
        return new GitLabIssueKey(issue.getId(), issue.getIid(), projectPath);
    }

    public static GitLabIssueKey fromJsonString(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readValue(json, GitLabIssueKey.class);
        }
        catch (IOException e) {
            throw new BugTrackerRemoteException((Throwable)e);
        }
    }
}

