/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api.models;

import gitlabbt.org.gitlab4j.api.models.AccessLevel;
import gitlabbt.org.gitlab4j.api.models.CustomAttribute;
import gitlabbt.org.gitlab4j.models.Constants;
import gitlabbt.org.gitlab4j.models.GitLabForm;
import gitlabbt.org.gitlab4j.models.utils.JacksonJson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GroupFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Long> skipGroups;
    private Boolean allAvailable;
    private String search;
    private Constants.GroupOrderBy orderBy;
    private Constants.SortOrder sort;
    private Boolean statistics;
    private Boolean withCustomAttributes;
    private Boolean owned;
    private AccessLevel accessLevel;
    private Boolean topLevelOnly;
    private List<CustomAttribute> customAttributesFilter = new ArrayList<CustomAttribute>();

    public GroupFilter withSkipGroups(List<Long> skipGroups) {
        this.skipGroups = skipGroups;
        return this;
    }

    public GroupFilter withAllAvailable(Boolean allAvailable) {
        this.allAvailable = allAvailable;
        return this;
    }

    public GroupFilter withSearch(String search) {
        this.search = search;
        return this;
    }

    public GroupFilter withOrderBy(Constants.GroupOrderBy orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public GroupFilter withSortOder(Constants.SortOrder sort) {
        this.sort = sort;
        return this;
    }

    public GroupFilter withStatistics(Boolean statistics) {
        this.statistics = statistics;
        return this;
    }

    public GroupFilter withCustomAttributes(Boolean withCustomAttributes) {
        this.withCustomAttributes = withCustomAttributes;
        return this;
    }

    public GroupFilter withCustomAttributeFilter(String key, String value) {
        this.customAttributesFilter.add(new CustomAttribute().withKey(key).withValue(value));
        return this;
    }

    public GroupFilter withOwned(Boolean owned) {
        this.owned = owned;
        return this;
    }

    public GroupFilter withMinAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
        return this;
    }

    public GroupFilter withTopLevelOnly(Boolean topLevelOnly) {
        this.topLevelOnly = topLevelOnly;
        return this;
    }

    public GitLabForm getQueryParams() {
        GitLabForm form = new GitLabForm().withParam("skip_groups", this.skipGroups).withParam("all_available", this.allAvailable).withParam("search", this.search).withParam("order_by", (Object)this.orderBy).withParam("sort", (Object)this.sort).withParam("statistics", this.statistics).withParam("with_custom_attributes", this.withCustomAttributes).withParam("owned", this.owned).withParam("min_access_level", this.accessLevel).withParam("top_level_only", this.topLevelOnly);
        for (CustomAttribute customAttribute : this.customAttributesFilter) {
            form.withParam(String.format("custom_attributes[%s]", customAttribute.getKey()), customAttribute.getValue());
        }
        return form;
    }

    public String toString() {
        return JacksonJson.toJsonString(this);
    }
}

