/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.AccessLevel;
import gitlabbt.org.gitlab4j.api.models.AccessRequest;
import gitlabbt.org.gitlab4j.api.models.AuditEvent;
import gitlabbt.org.gitlab4j.api.models.Badge;
import gitlabbt.org.gitlab4j.api.models.CustomAttribute;
import gitlabbt.org.gitlab4j.api.models.Group;
import gitlabbt.org.gitlab4j.api.models.GroupAccessToken;
import gitlabbt.org.gitlab4j.api.models.GroupFilter;
import gitlabbt.org.gitlab4j.api.models.GroupHook;
import gitlabbt.org.gitlab4j.api.models.GroupHookParams;
import gitlabbt.org.gitlab4j.api.models.GroupParams;
import gitlabbt.org.gitlab4j.api.models.GroupProjectsFilter;
import gitlabbt.org.gitlab4j.api.models.ImpersonationToken;
import gitlabbt.org.gitlab4j.api.models.Iteration;
import gitlabbt.org.gitlab4j.api.models.IterationFilter;
import gitlabbt.org.gitlab4j.api.models.LdapGroupLink;
import gitlabbt.org.gitlab4j.api.models.Member;
import gitlabbt.org.gitlab4j.api.models.Project;
import gitlabbt.org.gitlab4j.api.models.SamlGroupLink;
import gitlabbt.org.gitlab4j.api.models.UploadedFile;
import gitlabbt.org.gitlab4j.api.models.Variable;
import gitlabbt.org.gitlab4j.api.models.Visibility;
import gitlabbt.org.gitlab4j.models.Constants;
import gitlabbt.org.gitlab4j.models.utils.ISO8601;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class GroupApi
extends AbstractApi {
    public GroupApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Group> getGroups() throws GitLabApiException {
        String url = this.gitLabApi.getGitLabServerUrl();
        if (url.startsWith("https://gitlab.com")) {
            GitLabApi.getLogger().warning("Fetching all groups from " + url + " may take many minutes to complete, use Pager<Group> getGroups(int) instead.");
        }
        return this.getGroups(this.getDefaultPerPage()).all();
    }

    public List<Group> getGroups(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups");
        return response.readEntity(new GenericType<List<Group>>(){});
    }

    public Pager<Group> getGroups(int itemsPerPage) throws GitLabApiException {
        return new Pager<Group>(this, Group.class, itemsPerPage, null, "groups");
    }

    public Stream<Group> getGroupsStream() throws GitLabApiException {
        return this.getGroups(this.getDefaultPerPage()).stream();
    }

    public List<Group> getGroups(String search) throws GitLabApiException {
        return this.getGroups(search, this.getDefaultPerPage()).all();
    }

    public List<Group> getGroups(String search, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, formData.asMap(), "groups");
        return response.readEntity(new GenericType<List<Group>>(){});
    }

    public Pager<Group> getGroups(String search, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search);
        return new Pager<Group>(this, Group.class, itemsPerPage, formData.asMap(), "groups");
    }

    public Stream<Group> getGroupsStream(String search) throws GitLabApiException {
        return this.getGroups(search, this.getDefaultPerPage()).stream();
    }

    public List<Group> getGroups(GroupFilter filter) throws GitLabApiException {
        return this.getGroups(filter, this.getDefaultPerPage()).all();
    }

    public Pager<Group> getGroups(GroupFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(filter.getQueryParams());
        return new Pager<Group>(this, Group.class, itemsPerPage, formData.asMap(), "groups");
    }

    public Stream<Group> getGroupsStream(GroupFilter filter) throws GitLabApiException {
        return this.getGroups(filter, this.getDefaultPerPage()).stream();
    }

    public List<Group> getSubGroups(Object groupIdOrPath) throws GitLabApiException {
        return this.getSubGroups(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<Group> getSubGroups(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Group>(this, Group.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "subgroups");
    }

    public Stream<Group> getSubGroupsStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getSubGroups(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<Group> getSubGroups(Object groupIdOrPath, List<Integer> skipGroups, Boolean allAvailable, String search, Constants.GroupOrderBy orderBy, Constants.SortOrder sortOrder, Boolean statistics, Boolean owned) throws GitLabApiException {
        return this.getSubGroups(groupIdOrPath, skipGroups, allAvailable, search, orderBy, sortOrder, statistics, owned, this.getDefaultPerPage()).all();
    }

    public List<Group> getSubGroups(Object groupIdOrPath, List<Integer> skipGroups, Boolean allAvailable, String search, Constants.GroupOrderBy orderBy, Constants.SortOrder sortOrder, Boolean statistics, Boolean owned, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("skip_groups", skipGroups).withParam("all_available", allAvailable).withParam("search", search).withParam("order_by", (Object)orderBy).withParam("sort_order", (Object)sortOrder).withParam("statistics", statistics).withParam("owned", owned).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "subgroups");
        return response.readEntity(new GenericType<List<Group>>(){});
    }

    public Pager<Group> getSubGroups(Object groupIdOrPath, List<Integer> skipGroups, Boolean allAvailable, String search, Constants.GroupOrderBy orderBy, Constants.SortOrder sortOrder, Boolean statistics, Boolean owned, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("skip_groups", skipGroups).withParam("all_available", allAvailable).withParam("search", search).withParam("order_by", (Object)orderBy).withParam("sort_order", (Object)sortOrder).withParam("statistics", statistics).withParam("owned", owned);
        return new Pager<Group>(this, Group.class, itemsPerPage, formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "subgroups");
    }

    public Stream<Group> getSubGroupsStream(Object groupIdOrPath, List<Integer> skipGroups, Boolean allAvailable, String search, Constants.GroupOrderBy orderBy, Constants.SortOrder sortOrder, Boolean statistics, Boolean owned) throws GitLabApiException {
        return this.getSubGroups(groupIdOrPath, skipGroups, allAvailable, search, orderBy, sortOrder, statistics, owned, this.getDefaultPerPage()).stream();
    }

    public List<Group> getDescendantGroups(Object groupIdOrPath, GroupFilter filter) throws GitLabApiException {
        return this.getDescendantGroups(groupIdOrPath, filter, this.getDefaultPerPage()).all();
    }

    public Pager<Group> getDescendantGroups(Object groupIdOrPath, GroupFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(filter.getQueryParams());
        return new Pager<Group>(this, Group.class, itemsPerPage, formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "descendant_groups");
    }

    public Stream<Group> getDescendantGroupsStream(Object groupIdOrPath, GroupFilter filter) throws GitLabApiException {
        return this.getDescendantGroups(groupIdOrPath, filter, this.getDefaultPerPage()).stream();
    }

    public List<Project> getProjects(Object groupIdOrPath, GroupProjectsFilter filter) throws GitLabApiException {
        return this.getProjects(groupIdOrPath, filter, this.getDefaultPerPage()).all();
    }

    public Pager<Project> getProjects(Object groupIdOrPath, GroupProjectsFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(filter.getQueryParams());
        return new Pager<Project>(this, Project.class, itemsPerPage, formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "projects");
    }

    public Stream<Project> getProjectsStream(Object groupIdOrPath, GroupProjectsFilter filter) throws GitLabApiException {
        return this.getProjects(groupIdOrPath, filter, this.getDefaultPerPage()).stream();
    }

    public List<Project> getProjects(Object groupIdOrPath) throws GitLabApiException {
        return this.getProjects(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Project> getProjects(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "projects");
        return response.readEntity(new GenericType<List<Project>>(){});
    }

    public Pager<Project> getProjects(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Project>(this, Project.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "projects");
    }

    public Stream<Project> getProjectsStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getProjects(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Group getGroup(Object groupIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath));
        return response.readEntity(Group.class);
    }

    public Optional<Group> getOptionalGroup(Object groupIdOrPath) {
        try {
            return Optional.ofNullable(this.getGroup(groupIdOrPath));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Group createGroup(GroupParams params) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, params.getForm(true), "groups");
        return response.readEntity(Group.class);
    }

    public Group updateGroup(Object groupIdOrPath, GroupParams params) throws GitLabApiException {
        Response response = this.putWithFormData(Response.Status.OK, params.getForm(false), "groups", this.getGroupIdOrPath(groupIdOrPath));
        return response.readEntity(Group.class);
    }

    public Group addGroup(String name, String path) throws GitLabApiException {
        Form formData = new Form();
        formData.param("name", name);
        formData.param("path", path);
        Response response = this.post(Response.Status.CREATED, formData, "groups");
        return response.readEntity(Group.class);
    }

    public Group addGroup(Group group) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", group.getName(), true).withParam("path", group.getPath(), true).withParam("description", group.getDescription()).withParam("visibility", (Object)group.getVisibility()).withParam("lfs_enabled", group.getLfsEnabled()).withParam("request_access_enabled", group.getRequestAccessEnabled()).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : group.getParentId());
        Response response = this.post(Response.Status.CREATED, (Form)formData, "groups");
        return response.readEntity(Group.class);
    }

    public Group addGroup(String name, String path, String description, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Long parentId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("path", path, true).withParam("description", description).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : parentId);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "groups");
        return response.readEntity(Group.class);
    }

    public Group updateGroup(Group group) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", group.getName()).withParam("path", group.getPath()).withParam("description", group.getDescription()).withParam("visibility", (Object)group.getVisibility()).withParam("lfs_enabled", group.getLfsEnabled()).withParam("request_access_enabled", group.getRequestAccessEnabled()).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : group.getParentId());
        Response response = this.put(Response.Status.OK, formData.asMap(), "groups", group.getId());
        return response.readEntity(Group.class);
    }

    public Group updateGroup(Object groupIdOrPath, String name, String path, String description, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Long parentId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", this.isApiVersion(GitLabApi.ApiVersion.V3) ? null : parentId);
        Response response = this.put(Response.Status.OK, formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath));
        return response.readEntity(Group.class);
    }

    @Deprecated
    public Group addGroup(String name, String path, String description, Boolean membershipLock, Boolean shareWithGroupLock, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Long parentId, Integer sharedRunnersMinutesLimit) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("membership_lock", membershipLock).withParam("share_with_group_lock", shareWithGroupLock).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", parentId).withParam("shared_runners_minutes_limit", sharedRunnersMinutesLimit);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "groups");
        return response.readEntity(Group.class);
    }

    @Deprecated
    public Group updateGroup(Object groupIdOrPath, String name, String path, String description, Boolean membershipLock, Boolean shareWithGroupLock, Visibility visibility, Boolean lfsEnabled, Boolean requestAccessEnabled, Long parentId, Integer sharedRunnersMinutesLimit) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("path", path).withParam("description", description).withParam("membership_lock", membershipLock).withParam("share_with_group_lock", shareWithGroupLock).withParam("visibility", (Object)visibility).withParam("lfs_enabled", lfsEnabled).withParam("request_access_enabled", requestAccessEnabled).withParam("parent_id", parentId).withParam("shared_runners_minutes_limit", sharedRunnersMinutesLimit);
        Response response = this.put(Response.Status.OK, formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath));
        return response.readEntity(Group.class);
    }

    public void deleteGroup(Object groupIdOrPath) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "groups", this.getGroupIdOrPath(groupIdOrPath));
    }

    public List<Member> getMembers(Object groupIdOrPath) throws GitLabApiException {
        return this.getMembers(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Member> getMembers(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "members");
        return response.readEntity(new GenericType<List<Member>>(){});
    }

    public Pager<Member> getMembers(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Member>(this, Member.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "members");
    }

    public Stream<Member> getMembersStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getMembers(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Member getMember(Object groupIdOrPath, long userId) throws GitLabApiException {
        return this.getMember(groupIdOrPath, userId, false);
    }

    public Optional<Member> getOptionalMember(Object groupIdOrPath, long userId) {
        try {
            return Optional.ofNullable(this.getMember(groupIdOrPath, userId, false));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Member getMember(Object groupIdOrPath, Long userId, Boolean includeInherited) throws GitLabApiException {
        Response response = includeInherited != false ? this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "members", "all", userId) : this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "members", userId);
        return response.readEntity(Member.class);
    }

    public Optional<Member> getOptionalMember(Object groupIdOrPath, Long userId, Boolean includeInherited) {
        try {
            return Optional.ofNullable(this.getMember(groupIdOrPath, userId, includeInherited));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<Member> getAllMembers(Object groupIdOrPath) throws GitLabApiException {
        return this.getAllMembers(groupIdOrPath, null, null);
    }

    @Deprecated
    public List<Member> getAllMembers(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "members", "all");
        return response.readEntity(new GenericType<List<Member>>(){});
    }

    public Pager<Member> getAllMembers(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getAllMembers(groupIdOrPath, null, null, itemsPerPage);
    }

    public Stream<Member> getAllMembersStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getAllMembersStream(groupIdOrPath, null, null);
    }

    public List<Member> getAllMembers(Object groupIdOrPath, String query, List<Long> userIds) throws GitLabApiException {
        return this.getAllMembers(groupIdOrPath, query, userIds, this.getDefaultPerPage()).all();
    }

    public Pager<Member> getAllMembers(Object groupIdOrPath, String query, List<Long> userIds, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("query", query).withParam("user_ids", userIds);
        return new Pager<Member>(this, Member.class, itemsPerPage, form.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "members", "all");
    }

    public Stream<Member> getAllMembersStream(Object groupIdOrPath, String query, List<Long> userIds) throws GitLabApiException {
        return this.getAllMembers(groupIdOrPath, query, userIds, this.getDefaultPerPage()).stream();
    }

    public Member addMember(Object groupIdOrPath, Long userId, Integer accessLevel) throws GitLabApiException {
        return this.addMember(groupIdOrPath, userId, accessLevel, null);
    }

    public Member addMember(Object groupIdOrPath, Long userId, AccessLevel accessLevel) throws GitLabApiException {
        return this.addMember(groupIdOrPath, userId, accessLevel.toValue(), null);
    }

    public Member addMember(Object groupIdOrPath, Long userId, AccessLevel accessLevel, Date expiresAt) throws GitLabApiException {
        return this.addMember(groupIdOrPath, userId, accessLevel.toValue(), expiresAt);
    }

    public Member addMember(Object groupIdOrPath, Long userId, Integer accessLevel, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("user_id", userId, true).withParam("access_level", accessLevel, true).withParam("expires_at", expiresAt, false);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "members");
        return response.readEntity(Member.class);
    }

    public Member updateMember(Object groupIdOrPath, Long userId, Integer accessLevel) throws GitLabApiException {
        return this.updateMember(groupIdOrPath, userId, accessLevel, null);
    }

    public Member updateMember(Object groupIdOrPath, Long userId, AccessLevel accessLevel) throws GitLabApiException {
        return this.updateMember(groupIdOrPath, userId, accessLevel.toValue(), null);
    }

    public Member updateMember(Object groupIdOrPath, Long userId, AccessLevel accessLevel, Date expiresAt) throws GitLabApiException {
        return this.updateMember(groupIdOrPath, userId, accessLevel.toValue(), expiresAt);
    }

    public Member updateMember(Object groupIdOrPath, Long userId, Integer accessLevel, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("access_level", accessLevel, true).withParam("expires_at", expiresAt, false);
        Response response = this.put(Response.Status.OK, formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "members", userId);
        return response.readEntity(Member.class);
    }

    public void removeMember(Object groupIdOrPath, Long userId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "members", userId);
    }

    public void ldapSync(Object groupIdOrPath) throws GitLabApiException {
        this.post(Response.Status.NO_CONTENT, (Form)null, "groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_sync");
    }

    public List<LdapGroupLink> getLdapGroupLinks(Object groupIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_group_links");
        return response.readEntity(new GenericType<List<LdapGroupLink>>(){});
    }

    public void addLdapGroupLink(Object groupIdOrPath, String cn, AccessLevel groupAccess, String provider) throws GitLabApiException {
        if (groupAccess == null) {
            throw new RuntimeException("groupAccess cannot be null or empty");
        }
        this.addLdapGroupLink(groupIdOrPath, cn, groupAccess.toValue(), provider);
    }

    public void addLdapGroupLink(Object groupIdOrPath, String cn, Integer groupAccess, String provider) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("cn", cn, true).withParam("group_access", groupAccess, true).withParam("provider", provider, true);
        this.post(Response.Status.CREATED, (Form)formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_group_links");
    }

    public void deleteLdapGroupLink(Object groupIdOrPath, String cn) throws GitLabApiException {
        if (cn == null || cn.trim().isEmpty()) {
            throw new RuntimeException("cn cannot be null or empty");
        }
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_group_links", cn);
    }

    public void deleteLdapGroupLink(Object groupIdOrPath, String cn, String provider) throws GitLabApiException {
        if (cn == null || cn.trim().isEmpty()) {
            throw new RuntimeException("cn cannot be null or empty");
        }
        if (provider == null || provider.trim().isEmpty()) {
            throw new RuntimeException("LDAP provider cannot be null or empty");
        }
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "ldap_group_links", provider, cn);
    }

    public List<SamlGroupLink> getSamlGroupLinks(Object groupIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "saml_group_links");
        return response.readEntity(new GenericType<List<SamlGroupLink>>(){});
    }

    public void addSamlGroupLink(Object groupIdOrPath, String samlGroupName, AccessLevel groupAccess) throws GitLabApiException {
        if (groupAccess == null) {
            throw new RuntimeException("groupAccess cannot be null or empty");
        }
        this.addSamlGroupLink(groupIdOrPath, samlGroupName, groupAccess.toValue());
    }

    public void addSamlGroupLink(Object groupIdOrPath, String samlGroupName, AccessLevel groupAccess, int memberRoleId) throws GitLabApiException {
        if (groupAccess == null) {
            throw new RuntimeException("groupAccess cannot be null or empty");
        }
        this.addSamlGroupLink(groupIdOrPath, samlGroupName, groupAccess.toValue(), (Integer)memberRoleId);
    }

    public void addSamlGroupLink(Object groupIdOrPath, String samlGroupName, Integer groupAccess) throws GitLabApiException {
        this.addSamlGroupLink(groupIdOrPath, samlGroupName, groupAccess, null);
    }

    public void addSamlGroupLink(Object groupIdOrPath, String samlGroupName, Integer groupAccess, Integer memberRoleId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("saml_group_name", samlGroupName, true).withParam("access_level", groupAccess, true).withParam("member_role_id", memberRoleId);
        this.post(Response.Status.CREATED, (Form)formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "saml_group_links");
    }

    public void deleteSamlGroupLink(Object groupIdOrPath, String samlGroupName) throws GitLabApiException {
        if (samlGroupName == null || samlGroupName.trim().isEmpty()) {
            throw new RuntimeException("samlGroupName cannot be null or empty");
        }
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "saml_group_links", samlGroupName);
    }

    public List<Variable> getVariables(Object groupIdOrPath) throws GitLabApiException {
        return this.getVariables(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Variable> getVariables(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "variables");
        return response.readEntity(new GenericType<List<Variable>>(){});
    }

    public Pager<Variable> getVariables(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Variable>(this, Variable.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "variables");
    }

    public Stream<Variable> getVariablesStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getVariables(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Variable getVariable(Object groupIdOrPath, String key) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "variables", key);
        return response.readEntity(Variable.class);
    }

    public Optional<Variable> getOptionalVariable(Object groupIdOrPath, String key) {
        try {
            return Optional.ofNullable(this.getVariable(groupIdOrPath, key));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Variable createVariable(Object groupIdOrPath, String key, String value, Boolean isProtected) throws GitLabApiException {
        return this.createVariable(groupIdOrPath, key, value, isProtected, false);
    }

    public Variable createVariable(Object groupIdOrPath, String key, String value, Boolean isProtected, Boolean masked) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("key", key, true).withParam("value", value, true).withParam("masked", masked).withParam("protected", isProtected);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "variables");
        return response.readEntity(Variable.class);
    }

    public Variable updateVariable(Object groupIdOrPath, String key, String value, Boolean isProtected) throws GitLabApiException {
        return this.updateVariable(groupIdOrPath, key, value, isProtected, false);
    }

    public Variable updateVariable(Object groupIdOrPath, String key, String value, Boolean isProtected, Boolean masked) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("value", value, true).withParam("masked", masked).withParam("protected", isProtected);
        Response response = this.putWithFormData(Response.Status.CREATED, formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "variables", key);
        return response.readEntity(Variable.class);
    }

    public void deleteVariable(Object groupIdOrPath, String key) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "variables", key);
    }

    public Project transferProject(Object groupIdOrPath, Object projectIdOrPath) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)null, "groups", this.getGroupIdOrPath(groupIdOrPath), "projects", this.getProjectIdOrPath(projectIdOrPath));
        return response.readEntity(Project.class);
    }

    public List<AuditEvent> getAuditEvents(Object groupIdOrPath, Date created_after, Date created_before) throws GitLabApiException {
        return this.getAuditEvents(groupIdOrPath, created_after, created_before, this.getDefaultPerPage()).all();
    }

    public Pager<AuditEvent> getAuditEvents(Object groupIdOrPath, Date created_after, Date created_before, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("created_before", ISO8601.toString(created_after, false)).withParam("created_after", ISO8601.toString(created_before, false));
        return new Pager<AuditEvent>(this, AuditEvent.class, itemsPerPage, form.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "audit_events");
    }

    public Stream<AuditEvent> getAuditEventsStream(Object groupIdOrPath, Date created_after, Date created_before) throws GitLabApiException {
        return this.getAuditEvents(groupIdOrPath, created_after, created_before, this.getDefaultPerPage()).stream();
    }

    public AuditEvent getAuditEvent(Object groupIdOrPath, Long auditEventId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "audit_events", auditEventId);
        return response.readEntity(AuditEvent.class);
    }

    public List<AccessRequest> getAccessRequests(Object groupIdOrPath) throws GitLabApiException {
        return this.getAccessRequests(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<AccessRequest> getAccessRequests(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<AccessRequest>(this, AccessRequest.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "access_requests");
    }

    public Stream<AccessRequest> getAccessRequestsStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getAccessRequests(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public AccessRequest requestAccess(Object groupIdOrPath) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)null, "groups", this.getGroupIdOrPath(groupIdOrPath), "access_requests");
        return response.readEntity(AccessRequest.class);
    }

    public AccessRequest approveAccessRequest(Object groupIdOrPath, Long userId, AccessLevel accessLevel) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("access_level", accessLevel);
        Response response = this.putWithFormData(Response.Status.CREATED, formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "access_requests", userId, "approve");
        return response.readEntity(AccessRequest.class);
    }

    public void denyAccessRequest(Object groupIdOrPath, Long userId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "access_requests", userId);
    }

    public List<Badge> getBadges(Object groupIdOrPath) throws GitLabApiException {
        return this.getBadges(groupIdOrPath, null);
    }

    public List<Badge> getBadges(Object groupIdOrPath, String badgeName) throws GitLabApiException {
        GitLabApiForm queryParam = new GitLabApiForm().withParam("name", badgeName);
        Response response = this.get(Response.Status.OK, queryParam.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "badges");
        return response.readEntity(new GenericType<List<Badge>>(){});
    }

    public Badge getBadge(Object groupIdOrPath, Long badgeId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "badges", badgeId);
        return response.readEntity(Badge.class);
    }

    public Optional<Badge> getOptionalBadge(Object groupIdOrPath, Long badgeId) {
        try {
            return Optional.ofNullable(this.getBadge(groupIdOrPath, badgeId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Badge addBadge(Object groupIdOrPath, String linkUrl, String imageUrl) throws GitLabApiException {
        return this.addBadge(groupIdOrPath, null, linkUrl, imageUrl);
    }

    public Badge addBadge(Object groupIdOrPath, String name, String linkUrl, String imageUrl) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, false).withParam("link_url", linkUrl, true).withParam("image_url", imageUrl, true);
        Response response = this.post(Response.Status.OK, (Form)formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "badges");
        return response.readEntity(Badge.class);
    }

    public Badge editBadge(Object groupIdOrPath, Long badgeId, String linkUrl, String imageUrl) throws GitLabApiException {
        return this.editBadge(groupIdOrPath, badgeId, null, linkUrl, imageUrl);
    }

    public Badge editBadge(Object groupIdOrPath, Long badgeId, String name, String linkUrl, String imageUrl) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, false).withParam("link_url", linkUrl, false).withParam("image_url", imageUrl, false);
        Response response = this.putWithFormData(Response.Status.OK, formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "badges", badgeId);
        return response.readEntity(Badge.class);
    }

    public void removeBadge(Object groupIdOrPath, Long badgeId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "badges", badgeId);
    }

    public Badge previewBadge(Object groupIdOrPath, String linkUrl, String imageUrl) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("link_url", linkUrl, true).withParam("image_url", imageUrl, true);
        Response response = this.get(Response.Status.OK, formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "badges", "render");
        return response.readEntity(Badge.class);
    }

    public Group setGroupAvatar(Object groupIdOrPath, File avatarFile) throws GitLabApiException {
        Response response = this.putUpload(Response.Status.OK, "avatar", avatarFile, "groups", this.getGroupIdOrPath(groupIdOrPath));
        return response.readEntity(Group.class);
    }

    public InputStream getAvatar(Object groupIdOrPath) throws GitLabApiException {
        Response response = this.getWithAccepts(Response.Status.OK, null, "*", "groups", this.getGroupIdOrPath(groupIdOrPath), "avatar");
        return response.readEntity(InputStream.class);
    }

    public Group shareGroup(Object groupIdOrPath, Long shareWithGroupId, AccessLevel groupAccess, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("group_id", shareWithGroupId, true).withParam("group_access", groupAccess, true).withParam("expires_at", expiresAt);
        Response response = this.post(Response.Status.OK, (Form)formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "share");
        return response.readEntity(Group.class);
    }

    public void unshareGroup(Object groupIdOrPath, Long sharedWithGroupId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "share", sharedWithGroupId);
    }

    public List<CustomAttribute> getCustomAttributes(Object groupIdOrPath) throws GitLabApiException {
        return this.getCustomAttributes(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<CustomAttribute> getCustomAttributes(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<CustomAttribute>(this, CustomAttribute.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "custom_attributes");
    }

    public Stream<CustomAttribute> getCustomAttributesStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getCustomAttributes(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public CustomAttribute getCustomAttribute(Object groupIdOrPath, String key) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "custom_attributes", key);
        return response.readEntity(CustomAttribute.class);
    }

    public Optional<CustomAttribute> geOptionalCustomAttribute(Object groupIdOrPath, String key) {
        try {
            return Optional.ofNullable(this.getCustomAttribute(groupIdOrPath, key));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public CustomAttribute setCustomAttribute(Object groupIdOrPath, String key, String value) throws GitLabApiException {
        if (Objects.isNull(key) || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        if (Objects.isNull(value) || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null or empty");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("value", value);
        Response response = this.putWithFormData(Response.Status.OK, formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "custom_attributes", key);
        return response.readEntity(CustomAttribute.class);
    }

    public void deleteCustomAttribute(Object groupIdOrPath, String key) throws GitLabApiException {
        if (Objects.isNull(key) || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Key can't be null or empty");
        }
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "custom_attributes", key);
    }

    public List<Iteration> listGroupIterations(Object groupIdOrPath, IterationFilter filter) throws GitLabApiException {
        MultivaluedMap<String, String> queryParams = filter == null ? null : new GitLabApiForm(filter.getQueryParams()).asMap();
        Response response = this.get(Response.Status.OK, queryParams, "groups", this.getGroupIdOrPath(groupIdOrPath), "iterations");
        return response.readEntity(new GenericType<List<Iteration>>(){});
    }

    public List<GroupAccessToken> getGroupAccessTokens(Object groupIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "access_tokens");
        return response.readEntity(new GenericType<List<GroupAccessToken>>(){});
    }

    public GroupAccessToken getGroupAccessToken(Object groupIdOrPath, Long tokenId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "access_tokens", tokenId);
        return response.readEntity(GroupAccessToken.class);
    }

    public GroupAccessToken createGroupAccessToken(Object groupIdOrPath, String name, Date expiresAt, ImpersonationToken.Scope[] scopes, AccessLevel accessLevel) throws GitLabApiException {
        if (scopes == null || scopes.length == 0) {
            throw new RuntimeException("scopes cannot be null or empty");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("scopes", Arrays.asList(scopes)).withParam("expires_at", ISO8601.dateOnly(expiresAt)).withParam("access_level", accessLevel);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "access_tokens");
        return response.readEntity(GroupAccessToken.class);
    }

    public GroupAccessToken rotateGroupAccessToken(Object groupIdOrPath, Long tokenId) throws GitLabApiException {
        return this.rotateGroupAccessToken(groupIdOrPath, tokenId, null);
    }

    public GroupAccessToken rotateGroupAccessToken(Object groupIdOrPath, Long tokenId, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("expires_at", ISO8601.dateOnly(expiresAt));
        Response response = this.post(Response.Status.OK, (Form)formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "access_tokens", tokenId, "rotate");
        return response.readEntity(GroupAccessToken.class);
    }

    public void revokeGroupAccessToken(Object groupIdOrPath, Long tokenId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "access_tokens", tokenId);
    }

    public GroupHook addWebhook(Object groupIdOrPath, GroupHookParams groupHookParams) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, groupHookParams.getForm(), "groups", this.getGroupIdOrPath(groupIdOrPath), "hooks");
        return response.readEntity(GroupHook.class);
    }

    public List<UploadedFile> getUploadFiles(Object groupIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "uploads");
        return response.readEntity(new GenericType<List<UploadedFile>>(){});
    }
}

