/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.conversion;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.bugtracker.gitlab.domain.GitLabIssueCreationParameters;

public final class SquashToGitLabIssueConverter {
    public static GitLabIssueCreationParameters convert(AdvancedIssue advancedIssue) {
        Date createdAt = null;
        Integer mergeRequestToResolveId = null;
        Integer discussionToResolveId = null;
        return new GitLabIssueCreationParameters(SquashToGitLabIssueConverter.extractProjectPath(advancedIssue), SquashToGitLabIssueConverter.extractTitle(advancedIssue), SquashToGitLabIssueConverter.extractDescription(advancedIssue), SquashToGitLabIssueConverter.extractConfidential(advancedIssue), SquashToGitLabIssueConverter.extractAssigneeIds(advancedIssue), SquashToGitLabIssueConverter.extractMilestoneId(advancedIssue), SquashToGitLabIssueConverter.extractLabels(advancedIssue), createdAt, SquashToGitLabIssueConverter.extractDueDate(advancedIssue), mergeRequestToResolveId, discussionToResolveId, SquashToGitLabIssueConverter.extractLinkedIssues(advancedIssue), SquashToGitLabIssueConverter.extractEpicId(advancedIssue));
    }

    private static Boolean extractConfidential(AdvancedIssue advancedIssue) {
        String scalar = advancedIssue.getFieldValue("confidential").getScalar();
        return scalar != null && scalar.equals("true");
    }

    public static String extractProjectPath(AdvancedIssue advancedIssue) {
        return advancedIssue.getProject().getId();
    }

    private static String extractTitle(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("summary").getScalar();
    }

    private static String extractDescription(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("description").getScalar();
    }

    private static String extractLabels(AdvancedIssue advancedIssue) {
        List labelNames = Arrays.stream(advancedIssue.getFieldValue("labels").getComposite()).map(FieldValue::getScalar).collect(Collectors.toList());
        return String.join((CharSequence)",", labelNames);
    }

    private static List<Integer> extractAssigneeIds(AdvancedIssue advancedIssue) {
        FieldValue fieldValue = advancedIssue.getFieldValue("assignees");
        if (fieldValue.getComposite().length > 0) {
            return Arrays.stream(fieldValue.getComposite()).map(FieldValue::getId).map(SquashToGitLabIssueConverter::tryParseInteger).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Integer numericId = SquashToGitLabIssueConverter.tryParseInteger(fieldValue.getId());
        if (numericId == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(numericId);
    }

    private static Integer extractMilestoneId(AdvancedIssue advancedIssue) {
        String idAsString = advancedIssue.getFieldValue("milestone").getId();
        if (idAsString == null || StringUtils.isBlank((CharSequence)idAsString)) {
            return null;
        }
        return SquashToGitLabIssueConverter.tryParseInteger(idAsString);
    }

    private static Date extractDueDate(AdvancedIssue advancedIssue) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat.parse(advancedIssue.getFieldValue("dueDate").getScalar());
        }
        catch (IllegalArgumentException | ParseException ex) {
            return null;
        }
    }

    private static List<GitLabIssueCreationParameters.LinkedIssue> extractLinkedIssues(AdvancedIssue advancedIssue) {
        FieldValue linkIssuesValue;
        GitLabIssueCreationParameters.LinkedIssueType linkType = GitLabIssueCreationParameters.LinkedIssueType.RELATES;
        FieldValue linkTypeValue = advancedIssue.getFieldValue("linkedIssueType");
        if (linkTypeValue != null) {
            linkType = GitLabIssueCreationParameters.LinkedIssueType.valueOf(linkTypeValue.getId());
        }
        if ((linkIssuesValue = advancedIssue.getFieldValue("linkedIssues")) != null) {
            GitLabIssueCreationParameters.LinkedIssueType type = linkType;
            FieldValue[] values = linkIssuesValue.getComposite();
            if (values != null) {
                return Arrays.stream(values).map(fieldValue -> new GitLabIssueCreationParameters.LinkedIssue(type, fieldValue.getScalar())).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static Integer extractEpicId(AdvancedIssue advancedIssue) {
        FieldValue fieldValue = advancedIssue.getFieldValue("epic");
        if (fieldValue == null) {
            return null;
        }
        return SquashToGitLabIssueConverter.tryParseInteger(fieldValue.getId());
    }

    private static Integer tryParseInteger(String candidate) {
        try {
            return Integer.parseInt(candidate);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

