/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.caching;

import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.models.Epic;
import gitlabbt.org.gitlab4j.api.models.Project;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.BugTrackerAndPath;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.CachedValues;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.CompositeCacheKey;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.ValueCacheManager;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.GitLabApiWrapper;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

public class ValueCacheWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueCacheWorker.class);
    private final ValueCacheManager manager;
    private final int id;
    private final Object lock = new Object();

    ValueCacheWorker(ValueCacheManager valueCacheManager, int id) {
        this.manager = valueCacheManager;
        this.id = id;
    }

    public void start() {
        this.manager.getTaskScheduler().schedule(this::processInSynchronizedBlock, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInSynchronizedBlock() {
        Object object = this.lock;
        synchronized (object) {
            this.doProcess();
        }
    }

    private void doProcess() {
        while (!this.manager.getQueue().isEmpty()) {
            BugTrackerAndPath bugTrackerAndPath = this.manager.getQueue().poll();
            BugTracker bugTracker = bugTrackerAndPath.bugTracker();
            String projectPath = bugTrackerAndPath.path();
            Long bugtrackerId = bugTracker.getId();
            Credentials credentials = this.findCredentials(bugtrackerId, bugTracker);
            if (credentials == null) {
                LOGGER.warn("[Worker #{}] No credentials found for bugtracker {}. Cache cannot be used", (Object)this.id, (Object)bugtrackerId);
                continue;
            }
            this.updateCachedValues(bugTracker, credentials, projectPath);
        }
    }

    private Credentials findCredentials(Long bugtrackerId, BugTracker bugTracker) {
        StoredCredentialsManager storedCredentialsManager = this.manager.getStoredCredentialsManager();
        ManageableCredentials manageableCredentials = storedCredentialsManager.findReportingCacheCredentials(bugtrackerId.longValue());
        if (manageableCredentials == null) {
            return null;
        }
        return manageableCredentials.build(storedCredentialsManager, (ThirdPartyServer)bugTracker, null);
    }

    private void updateCachedValues(BugTracker bugTracker, Credentials credentials, String path) {
        LOGGER.trace("[Worker #{}] Updating cache for project {} and bug tracker {}", new Object[]{this.id, path, bugTracker.getId()});
        CompositeCacheKey key = new CompositeCacheKey(bugTracker.getId(), path);
        try (GitLabApiWrapper gitLabApiWrapper = this.createGitLabApiWrapper(bugTracker, credentials);){
            Project project = gitLabApiWrapper.getProject(path);
            Long bugTrackerId = bugTracker.getId();
            CachedValues cachedValues = CachedValues.of(this.manager.getUserPool().replaceWithReferences(bugTrackerId, gitLabApiWrapper.getProjectUsers(path)), this.manager.getLabelPool().replaceWithReferences(bugTrackerId, gitLabApiWrapper.getProjectLabels(path)), this.manager.getMilestonePool().replaceWithReferences(bugTrackerId, gitLabApiWrapper.getProjectMilestones(path)), this.manager.getEpicPool().replaceWithReferences(bugTrackerId, this.findEpics(gitLabApiWrapper, project)));
            this.manager.cacheMap.put(key, cachedValues);
            LOGGER.trace("[Worker #{}] Finished cache update for project {} and bug tracker {}", new Object[]{this.id, path, bugTracker.getId()});
        }
        catch (GitLabApiException e) {
            if (this.manager.cacheMap.containsKey(key)) {
                this.manager.cacheMap.put(key, this.manager.cacheMap.get(key).withLastUpdateError());
            } else {
                this.manager.cacheMap.put(key, CachedValues.error());
            }
            if (e.getHttpStatus() == 429) {
                LOGGER.info("[Worker #{}] Usage limit was hit for project {} and bug tracker {}. Cache update will be retried in {} minutes.", new Object[]{this.id, path, bugTracker.getId(), 5L, e});
                this.manager.retryLater(bugTracker, path);
            }
            Object message = "[Worker #%s] Error while updating cache for project %s and bug tracker %s.".formatted(this.id, path, bugTracker.getId());
            if (this.manager.cacheMap.get(key).hasCachedValues()) {
                message = (String)message + " The previously cached will be used until the next update.";
            }
            LOGGER.error((String)message, (Throwable)e);
        }
    }

    private List<Epic> findEpics(GitLabApiWrapper gitLabApiWrapper, Project project) {
        try {
            return gitLabApiWrapper.getEpics(project);
        }
        catch (GitLabApiException e) {
            LOGGER.trace("Error while fetching epics for project " + project.getPathWithNamespace(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private GitLabApiWrapper createGitLabApiWrapper(BugTracker bugTracker, Credentials credentials) {
        return new GitLabApiWrapper(bugTracker, credentials);
    }
}

