/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.BugzillaClient;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.StubIssue;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.exception.BugzillaExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.exception.BugzillaProjectNotFoundException;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.BugzillaClientOperation;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.CreateIssue;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.ForwardAttachments;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.GetAllUser;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.GetAssignableUser;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.GetBugzillaVersion;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.GetIssue;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.GetIssues;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.GetPriorities;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.GetProjectForCreateById;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.operations.GetProjectForCreateByName;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.BugzillaXmlrcpClient;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Bug;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Product;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.User;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.BugzillaXmlrpcException;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.BugzillaXmlrpcIssueNotFoundException;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.BugzillaXmlrpcLoginFailException;
import org.squashtest.tm.service.spi.BugTrackerConnector;

@Component
@Scope(value="prototype")
public class BugzillaClientImpl
implements BugzillaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(BugTrackerConnector.class);
    private static final String LOG_HEADER = "Bugzilla XML-RPC client : ";
    private static final String AN_ERROR_OCCURED = "an error occured during operation : ";
    @Value(value="${plugin.bugtracker.bugzilla.cache.enable:false}")
    private Boolean globalCacheEnabled = false;
    @Inject
    private BugzillaExceptionHandler bugzillaExceptionHandler;
    @Inject
    @Named(value="bugzillaConnectorMessageSource")
    private MessageSource messageSource;
    private BugzillaXmlrcpClient manager;

    @Override
    public void init(BugTracker bugTracker, BasicAuthenticationCredentials credentials) {
        try {
            this.manager = new BugzillaXmlrcpClient(this.globalCacheEnabled, bugTracker.getUrl());
            this.manager.login(credentials.getUsername(), String.valueOf(credentials.getPassword()));
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw this.logAndThrowLocalException("Bugzilla XML-RPC client : url " + bugTracker.getUrl() + " is invalid", exception);
        }
    }

    @Override
    public Iterable<String> getAllPriorities() {
        GetPriorities operation = new GetPriorities(this.manager);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Bug getIssue(String issueKey) {
        GetIssue operation = new GetIssue(this.manager, issueKey);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Bug createIssue(Bug inputIssue) {
        CreateIssue operation = new CreateIssue(this.manager, inputIssue);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Product findProjectForCreateByName(String projectKey) {
        GetProjectForCreateByName operation = new GetProjectForCreateByName(this.manager, projectKey);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Product findProjectForCreateById(Integer id) {
        GetProjectForCreateById operation = new GetProjectForCreateById(this.manager, id);
        return this.doInCatchBlock(operation);
    }

    @Override
    public List<Bug> getIssues(List<String> issueKeys) {
        GetIssues operation = new GetIssues(this.manager, issueKeys);
        Object issues = new ArrayList();
        try {
            issues = operation.doIt();
        }
        catch (BugzillaXmlrpcException exception) {
            LOGGER.trace("Bugzilla XML-RPC client : an error occured during operation : " + operation.getName(), (Throwable)exception);
            this.findDeletedIssues(issueKeys, (List<Bug>)issues);
        }
        return issues;
    }

    private void findDeletedIssues(List<String> issueKeys, List<Bug> issues) {
        LOGGER.debug("looking for deleted issues among {}", issueKeys);
        for (String issueKey : issueKeys) {
            GetIssues getIssue = new GetIssues(this.manager, Collections.singletonList(issueKey));
            try {
                issues.addAll((Collection<Bug>)getIssue.doIt());
                LOGGER.trace("\tissue : {} - alive", (Object)issueKey);
            }
            catch (BugzillaXmlrpcException exp) {
                LOGGER.debug("Bugzilla XML-RPC client : The issue " + issueKey + "has been moved or deleted. It will be stubbed. The error encountered was: " + String.valueOf(exp));
                issues.add(new StubIssue(issueKey, this.messageSource, LocaleContextHolder.getLocale()));
            }
        }
    }

    @Override
    public List<User> getAssignableUser(String name) {
        GetAssignableUser operation = new GetAssignableUser(this.manager, name);
        return this.doInCatchBlock(operation);
    }

    @Override
    public List<User> getAllUser() {
        GetAllUser operation = new GetAllUser(this.manager);
        return this.doInCatchBlock(operation);
    }

    @Override
    public String getBugzillaVersion() {
        GetBugzillaVersion operation = new GetBugzillaVersion(this.manager);
        return this.doInCatchBlock(operation);
    }

    @Override
    public void forwardAttachments(String remoteIssueKey, List<Attachment> attachments) {
        ForwardAttachments operation = new ForwardAttachments(this.manager, remoteIssueKey, attachments);
        this.doInCatchBlock(operation);
    }

    @Override
    public void verifyAssigneAssignable(Bug inputIssue) {
        GetAllUser operation = new GetAllUser(this.manager);
        String assigne = inputIssue.getAssignee();
        List<User> users = this.doInCatchBlock(operation);
        boolean assignable = false;
        if (assigne == null || "".equals(assigne)) {
            assignable = true;
        } else {
            for (User u : users) {
                if (!u.getName().equals(assigne)) continue;
                assignable = true;
                break;
            }
            if (!assignable) {
                throw this.bugzillaExceptionHandler.userNotAssignable(new Exception());
            }
        }
    }

    private BugTrackerLocalException logAndThrowLocalException(String message, Exception cause) {
        LOGGER.error(message);
        return new BugTrackerLocalException(message, (Throwable)cause);
    }

    private <ANY> ANY doInCatchBlock(BugzillaClientOperation<? extends ANY> operation) {
        try {
            return operation.doIt();
        }
        catch (BugzillaXmlrpcLoginFailException e) {
            LOGGER.error("Bugzilla XML-RPC client : an error occured during operation : login", (Throwable)e);
            throw this.bugzillaExceptionHandler.authenticationException(e);
        }
        catch (BugzillaXmlrpcIssueNotFoundException e) {
            LOGGER.error("Bugzilla XML-RPC client : an error occured during operation : login", (Throwable)e);
            throw this.bugzillaExceptionHandler.issueNotFoundException(e);
        }
        catch (BugzillaProjectNotFoundException e) {
            LOGGER.error("Bugzilla XML-RPC client : an error occured during operation : project not found", (Throwable)e);
            throw this.bugzillaExceptionHandler.projectNotFound(e);
        }
        catch (BugzillaXmlrpcException e) {
            LOGGER.error("Bugzilla XML-RPC client : an error occured during operation : " + operation.getName(), (Throwable)e);
            throw this.bugzillaExceptionHandler.genericError(e);
        }
    }
}

