/*
 * Decompiled with CFR 0.152.
 */
package bugzilla.org.apache.xmlrpc.parser;

import bugzilla.org.apache.ws.commons.util.NamespaceContextImpl;
import bugzilla.org.apache.xmlrpc.common.TypeFactory;
import bugzilla.org.apache.xmlrpc.common.XmlRpcStreamConfig;
import bugzilla.org.apache.xmlrpc.parser.RecursiveTypeParserImpl;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlRpcRequestParser
extends RecursiveTypeParserImpl {
    private int level;
    private boolean inMethodName;
    private String methodName;
    private List params;

    public XmlRpcRequestParser(XmlRpcStreamConfig pConfig, TypeFactory pTypeFactory) {
        super(pConfig, new NamespaceContextImpl(), pTypeFactory);
    }

    protected void addResult(Object pResult) {
        this.params.add(pResult);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.level = 0;
        this.inMethodName = false;
        this.methodName = null;
        this.params = null;
    }

    public void characters(char[] pChars, int pOffset, int pLength) throws SAXException {
        if (this.inMethodName) {
            String s = new String(pChars, pOffset, pLength);
            this.methodName = this.methodName == null ? s : this.methodName + s;
        } else {
            super.characters(pChars, pOffset, pLength);
        }
    }

    public void startElement(String pURI, String pLocalName, String pQName, Attributes pAttrs) throws SAXException {
        switch (this.level++) {
            case 0: {
                if ("".equals(pURI) && "methodCall".equals(pLocalName)) break;
                throw new SAXParseException("Expected root element 'methodCall', got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 1: {
                if (this.methodName == null) {
                    if ("".equals(pURI) && "methodName".equals(pLocalName)) {
                        this.inMethodName = true;
                        break;
                    }
                    throw new SAXParseException("Expected methodName element, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                if (this.params == null) {
                    if ("".equals(pURI) && "params".equals(pLocalName)) {
                        this.params = new ArrayList();
                        break;
                    }
                    throw new SAXParseException("Expected params element, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                throw new SAXParseException("Expected /methodCall, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 2: {
                if ("".equals(pURI) && "param".equals(pLocalName)) break;
                throw new SAXParseException("Expected param element, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 3: {
                if (!"".equals(pURI) || !"value".equals(pLocalName)) {
                    throw new SAXParseException("Expected value element, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                this.startValueTag();
                break;
            }
            default: {
                super.startElement(pURI, pLocalName, pQName, pAttrs);
            }
        }
    }

    public void endElement(String pURI, String pLocalName, String pQName) throws SAXException {
        switch (--this.level) {
            case 0: {
                break;
            }
            case 1: {
                if (this.inMethodName) {
                    if ("".equals(pURI) && "methodName".equals(pLocalName)) {
                        if (this.methodName == null) {
                            this.methodName = "";
                        }
                    } else {
                        throw new SAXParseException("Expected /methodName, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                    }
                    this.inMethodName = false;
                    break;
                }
                if ("".equals(pURI) && "params".equals(pLocalName)) break;
                throw new SAXParseException("Expected /params, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 2: {
                if ("".equals(pURI) && "param".equals(pLocalName)) break;
                throw new SAXParseException("Expected /param, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 3: {
                if (!"".equals(pURI) || !"value".equals(pLocalName)) {
                    throw new SAXParseException("Expected /value, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                this.endValueTag();
                break;
            }
            default: {
                super.endElement(pURI, pLocalName, pQName);
            }
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List getParams() {
        return this.params;
    }
}

