/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;

public final class DelegateCommands {
    private static final String SEARCH_ASSIGNABLE_COMMAND = "searchassignable:";
    private static final Pattern GET_ASSIGNABLE_PROJECT = Pattern.compile("searchassignable:(.*)");

    private DelegateCommands() {
    }

    public static DelegateCommand buildSearchAssignableCommand(String projectKey) {
        return new DelegateCommand(SEARCH_ASSIGNABLE_COMMAND + projectKey, (Object)"");
    }

    public static boolean isSearchAssignableCommand(DelegateCommand command) {
        return command.getCommand().startsWith(SEARCH_ASSIGNABLE_COMMAND);
    }

    public static String getProjectFromCommand(DelegateCommand command) {
        return DelegateCommands.findInCommand(command, GET_ASSIGNABLE_PROJECT);
    }

    private static String findInCommand(DelegateCommand command, Pattern pattern) {
        String allcommand = command.getCommand();
        Matcher matcher = pattern.matcher(allcommand);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("REDMINE REST client : DelegateCommand '" + allcommand + "' doesn't specify a project");
    }
}

