/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.scm.git.internal;

import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.service.spi.ScmConnector;
import org.squashtest.tm.service.spi.ScmServerKind;

public abstract class BasicGitConnector
implements ScmConnector {
    private static final String GIVEN_PROTOCOL_NOT_SUPPORTED = "The given protocol %s is not supported.";

    public boolean supports(AuthenticationProtocol authenticationProtocol) {
        switch (authenticationProtocol) {
            case BASIC_AUTH: 
            case TOKEN_AUTH: {
                break;
            }
            default: {
                throw new IllegalArgumentException(GIVEN_PROTOCOL_NOT_SUPPORTED.formatted(authenticationProtocol.toString()));
            }
        }
        return true;
    }

    public AuthenticationProtocol[] getSupportedProtocols() {
        return new AuthenticationProtocol[]{AuthenticationProtocol.BASIC_AUTH, AuthenticationProtocol.TOKEN_AUTH};
    }

    public ScmServerKind getConnectorKind() {
        return ScmServerKind.git;
    }
}

