/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class EntityValidator
implements Validator {
    private static final String CODE_INVALID_ID = "invalid id";
    private static final String ID = "id";
    private static final String MESSAGE_NO_ENTITY_KNOWN = "No entity found for type %s and id %d.";
    @PersistenceContext
    protected EntityManager entityManager;

    public void checkEntityExist(Errors errors, Class entityClass, long entityId) {
        Object entity = this.entityManager.find(entityClass, (Object)entityId);
        if (entity == null) {
            errors.rejectValue(ID, CODE_INVALID_ID, MESSAGE_NO_ENTITY_KNOWN.formatted(entityClass.getSimpleName(), entityId));
        }
    }
}

