/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.plugin.rest.core.exception.FeatureDisabledException;
import org.squashtest.tm.plugin.rest.core.exception.FeatureDisabledForLicenseException;
import org.squashtest.tm.plugin.rest.service.RestFeatureAvailabilityService;
import org.squashtest.tm.service.internal.repository.TestAutomationServerDao;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;

@Service(value="restFeatureAvailabilityService")
@Transactional
public class RestFeatureAvailabilityServiceImpl
implements RestFeatureAvailabilityService {
    protected final UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService;
    protected final TestAutomationServerDao testAutomationServerDao;
    @Value(value="${squash.cloud-mode-enabled:false}")
    protected boolean isCloudModeEnabled;

    @Inject
    public RestFeatureAvailabilityServiceImpl(UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService, TestAutomationServerDao testAutomationServerDao) {
        this.ultimateLicenseAvailabilityService = ultimateLicenseAvailabilityService;
        this.testAutomationServerDao = testAutomationServerDao;
    }

    @Override
    public void denyFeatureForCloudPremium() throws FeatureDisabledException {
        if (this.isCloudModeEnabled && !this.ultimateLicenseAvailabilityService.isAvailable()) {
            throw new FeatureDisabledForLicenseException("This feature is not available on SquashTM Cloud Premium. Upgrade to a higher licence level to use it.");
        }
    }
}

