/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.databind.util.StdConverter;
import jakarta.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.plugin.rest.jackson.model.UnauthorizedResource;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component
public class UnauthorizedResourcesConverter
extends StdConverter<EntityModel<? extends Identified>, EntityModel<?>> {
    @Inject
    private PermissionEvaluationService permService;
    @Inject
    private LinkRelationProvider relProvider;

    public EntityModel<?> convert(EntityModel<? extends Identified> value) {
        if (this.permService.canRead(value.getContent())) {
            return value;
        }
        return this.createUnauthorized(value);
    }

    private <T extends Identified> EntityModel<UnauthorizedResource> createUnauthorized(EntityModel<T> resource) {
        Identified entity = (Identified)resource.getContent();
        if (entity != null) {
            LinkRelation entityType = this.relProvider.getItemResourceRelFor(entity.getClass());
            UnauthorizedResource unauthRes = new UnauthorizedResource(entityType.value(), entity.getId());
            return EntityModel.of((Object)unauthRes, (Iterable)resource.getLinks());
        }
        return null;
    }
}

