/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationFilterExpression;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.PersistentEntity;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.ExecutionStepAndCustomFields;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDtoForExecution;
import org.squashtest.tm.plugin.rest.service.RestExecutionStepService;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.validators.CustomFieldValueHintedValidator;
import org.squashtest.tm.plugin.rest.validators.DenormalizedFieldValueHintedValidator;

@RestApiController(value=ExecutionStep.class)
@UseDefaultRestApiConfiguration
public class RestExecutionStepController
extends BaseRestController {
    public static final String PATCH_DYNAMIC_FILTER = "*, execution[execution_status]";
    @Inject
    private RestExecutionStepService restExecutionStepService;
    @Inject
    private CustomFieldValueHintedValidator cufValidator;
    @Inject
    private DenormalizedFieldValueHintedValidator denoValidator;
    @Inject
    private RestIssueService restIssueService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.cufValidator});
        binder.addValidators(new Validator[]{this.denoValidator});
    }

    @GetMapping(value={"/execution-steps/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, execution[execution_status]")
    public ResponseEntity<EntityModel<ExecutionStep>> findExecutionStep(@PathVariable(value="id") long id) {
        ExecutionStep executionStep = this.restExecutionStepService.getOne(id);
        EntityModel res = this.toEntityModel((Identified)executionStep);
        res.add(this.linkService.createLinkTo((Identified)executionStep.getProject()));
        res.add(this.linkService.createLinkTo((Identified)executionStep.getExecution()));
        res.add(this.linkService.createRelationTo((Identified)executionStep, "attachments"));
        res.add(this.linkService.createRelationTo((Identified)executionStep, "issues"));
        return ResponseEntity.ok((Object)res);
    }

    @PatchMapping(value={"/execution-steps/{id}/execution-status/{status}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, execution[execution_status]")
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.execution.ExecutionStep' , 'WRITE')")
    public ResponseEntity<EntityModel<ExecutionStep>> modifyExecutionStatus(@PathVariable(value="id") long id, @PathVariable(value="status") String status) {
        try {
            ExecutionStatus validatedStatus = ExecutionStatus.valueOf((String)status.toUpperCase());
            this.restExecutionStepService.modifyExecutionStatus(id, validatedStatus);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EnumConstantNotPresentException(ExecutionStatus.class, "Execution status " + status + " does not exist");
        }
        ExecutionStep executionStep = this.restExecutionStepService.getOne(id);
        EntityModel res = this.toEntityModel((Identified)executionStep);
        res.add(this.linkService.createLinkTo((Identified)executionStep.getProject()));
        res.add(this.linkService.createLinkTo((Identified)executionStep.getExecution()));
        return ResponseEntity.ok((Object)res);
    }

    @PatchMapping(value={"/execution-steps/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, execution[execution_status]")
    @DeserializationFilterExpression(value="comment, custom_fields")
    public ResponseEntity<EntityModel<ExecutionStep>> patchExecutionStep(@Validated @PersistentEntity ExecutionStepAndCustomFields step) {
        this.restExecutionStepService.updateStep(step);
        ExecutionStep unwrapped = (ExecutionStep)step.getWrapped();
        EntityModel res = this.toEntityModel((Identified)unwrapped);
        res.add(this.linkService.createLinkTo((Identified)unwrapped.getProject()));
        res.add(this.linkService.createLinkTo((Identified)unwrapped.getExecution()));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/execution-steps/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="*, execution")
    public ResponseEntity<PagedModel<EntityModel<IssueDtoForExecution>>> findExecutionStepsIssues(@PathVariable(value="id") long id, Pageable pageable) {
        ExecutionStep executionStep = this.restExecutionStepService.getOne(id);
        if (executionStep == null) {
            throw new IllegalArgumentException("Execution step with id " + id + " does not exist");
        }
        List<Execution> executions = this.restExecutionStepService.getExecutionFromExecutionStep(id);
        Optional<Long> firstExecutionId = executions.stream().findFirst().map(Execution::getId);
        Long idOfFirstExecution = firstExecutionId.get();
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(Collections.singletonList(idOfFirstExecution), pageable);
        Page pagedIssueForExecution = pagedIssue.map(this::convertToIssueDtoForExecution);
        ArrayList<IssueDtoForExecution> filteredIssues = new ArrayList<IssueDtoForExecution>();
        for (IssueDtoForExecution issue : pagedIssueForExecution.getContent()) {
            List<ExecutionStep> executionSteps = this.restExecutionStepService.getExecutionStepFromIssue(issue.getRemoteIssueId(), idOfFirstExecution);
            issue.setExecutionSteps(new HashSet<ExecutionStep>(executionSteps));
            if (!executionSteps.stream().anyMatch(step -> step.getId() == id)) continue;
            filteredIssues.add(issue);
            issue.setExecutionSteps(new HashSet<ExecutionStep>());
        }
        PageImpl pagedIssueToReturn = new PageImpl(filteredIssues, pageable, (long)filteredIssues.size());
        PagedModel res = this.pageAssembler.toModel((Page)pagedIssueToReturn);
        return ResponseEntity.ok((Object)res);
    }

    private IssueDtoForExecution convertToIssueDtoForExecution(IssueDto issueDto) {
        return new IssueDtoForExecution(issueDto.getRemoteIssueId(), issueDto.getUrl());
    }
}

