/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignFolderDto;
import org.squashtest.tm.plugin.rest.jackson.model.FolderTreeDto;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.jackson.model.ParentFolderTreeDto;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectTreeDto;
import org.squashtest.tm.plugin.rest.service.RestCampaignFolderService;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.service.RestProjectService;
import org.squashtest.tm.plugin.rest.validators.CampaignFolderPatchValidator;
import org.squashtest.tm.plugin.rest.validators.CampaignFolderPostValidator;

@RestApiController(value=CampaignFolder.class)
@UseDefaultRestApiConfiguration
public class RestCampaignFolderController
extends BaseRestController {
    private static final String CAMPAIGN_FOLDER_TYPE = "campaign-folder";
    @Inject
    private RestCampaignFolderService service;
    @Inject
    private CampaignFolderPostValidator campaignFolderPostValidator;
    @Inject
    private CampaignFolderPatchValidator campaignFolderPatchValidator;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestProjectService projectService;
    @Inject
    private RestIssueService restIssueService;

    @GetMapping(value={"/campaign-folders"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedModel<EntityModel<CampaignFolder>>> findAllReadableTestCaseFolders(Pageable pageable) {
        Page<CampaignFolder> folders = this.service.findAllReadable(pageable);
        PagedModel res = this.toPagedModel(folders);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/campaign-folders/tree/{projectIds}"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<List<ProjectTreeDto>> findCampaignFolderByProject(@PathVariable(value="projectIds") List<Long> projectIds) {
        ArrayList<Long> alreadyAddedIds = new ArrayList<Long>();
        List<Long> readableProjectIds = this.projectService.getReadableProjectIdsOnCampaignLibrary(projectIds);
        List<CampaignFolder> folders = this.service.findCampaignFolderByProject(readableProjectIds);
        List<ParentFolderTreeDto> tree = this.getCampaignFolderTree(folders, alreadyAddedIds);
        List<ProjectTreeDto> projTree = this.buildProjectTreeFromParentFolders(tree, readableProjectIds);
        return ResponseEntity.ok(projTree);
    }

    @GetMapping(value={"/campaign-folders/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<EntityModel<CampaignFolder>> findCampaignFolder(@PathVariable(value="id") long id) {
        CampaignFolder campaignFolder = this.service.getOne(id);
        EntityModel res = this.toEntityModel((Identified)campaignFolder);
        res.add(this.createLinkTo((Identified)campaignFolder.getProject()));
        res.add(this.createRelationTo("content"));
        res.add(this.createRelationTo("attachments"));
        res.add(this.createRelationTo("issues"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/campaign-folders/{id}/content"})
    @ResponseBody
    @DynamicFilterExpression(value="name,reference")
    public ResponseEntity<PagedModel<EntityModel<CampaignLibraryNode>>> findCampaignFolderContent(@PathVariable(value="id") long folderId, @SortDefault(sort={"nodes.id"}, direction=Sort.Direction.ASC) Pageable pageable, ContentInclusion include) {
        SingleRelPagedResources res = this.toPagedResourcesWithRel(switch (include) {
            case ContentInclusion.NESTED -> this.service.findFolderAllContent(folderId, pageable);
            default -> this.service.findFolderContent(folderId, pageable);
        }, "content");
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/campaign-folders"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<EntityModel<CampaignFolder>> createCampaignFolder(@RequestBody CampaignFolderDto folderDto) throws BindException, InvocationTargetException, IllegalAccessException {
        this.campaignFolderPostValidator.validatePostCampaignFolder(folderDto);
        CampaignFolder folder = this.service.addCampaignFolder(folderDto);
        EntityModel res = this.toEntityModel((Identified)folder);
        this.linksHelper.addAllLinksForCampaignFolder((EntityModel<CampaignFolder>)res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/campaign-folders/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<EntityModel<CampaignFolder>> patchCampaignFolder(@RequestBody CampaignFolderDto folderPatch, @PathVariable(value="id") long id) throws BindException {
        folderPatch.setId(id);
        this.campaignFolderPatchValidator.validatePatchCampaignFolder(folderPatch);
        CampaignFolder folder = this.service.patchCampaignFolder(folderPatch, id);
        EntityModel res = this.toEntityModel((Identified)folder);
        this.linksHelper.addAllLinksForCampaignFolder((EntityModel<CampaignFolder>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/campaign-folders/{ids}"})
    @ResponseBody
    public ResponseEntity<Void> deleteCampaignFolder(@PathVariable(value="ids") List<Long> folderIds) {
        this.service.deleteFolder(folderIds);
        return ResponseEntity.noContent().build();
    }

    private List<ParentFolderTreeDto> getCampaignFolderTree(List<CampaignFolder> folders, List<Long> alreadyAddedIds) {
        ArrayList<ParentFolderTreeDto> listDto = new ArrayList<ParentFolderTreeDto>();
        for (CampaignFolder folder : folders) {
            if (alreadyAddedIds.contains(folder.getId())) continue;
            ParentFolderTreeDto dto = new ParentFolderTreeDto();
            dto.setType(CAMPAIGN_FOLDER_TYPE);
            dto.setId(folder.getId());
            dto.setName(folder.getName());
            dto.setUrl(this.createSelfLink((Identified)folder).getHref());
            dto.setChildren(Collections.emptyList());
            dto.setProject(folder.getProject());
            if (folder.hasContent()) {
                List<CampaignFolder> folderChildren = this.getAllCampaignFolderFromContent(folder);
                List<ParentFolderTreeDto> cftd = this.getCampaignFolderTree(folderChildren, alreadyAddedIds);
                dto.setChildren(cftd);
            }
            alreadyAddedIds.add(folder.getId());
            listDto.add(dto);
        }
        return listDto;
    }

    private List<CampaignFolder> getAllCampaignFolderFromContent(CampaignFolder folder) {
        ArrayList<CampaignFolder> reqFolderList = new ArrayList<CampaignFolder>();
        for (CampaignLibraryNode rln : folder.getContent()) {
            if (!(rln instanceof CampaignFolder)) continue;
            CampaignFolder campaignFolder = (CampaignFolder)rln;
            reqFolderList.add(campaignFolder);
        }
        return reqFolderList;
    }

    private List<ProjectTreeDto> buildProjectTreeFromParentFolders(List<ParentFolderTreeDto> parentFolders, List<Long> projectIds) {
        if (!parentFolders.isEmpty()) {
            return this.appendProjectTreesWithFolderList(parentFolders);
        }
        if (!projectIds.isEmpty()) {
            return this.appendProjectTreesWithoutFolderList(projectIds);
        }
        return Collections.emptyList();
    }

    private List<ProjectTreeDto> appendProjectTreesWithFolderList(List<ParentFolderTreeDto> tree) {
        ArrayList<ProjectTreeDto> projTree = new ArrayList<ProjectTreeDto>();
        Map<Project, List<FolderTreeDto>> map = tree.stream().collect(Collectors.groupingBy(FolderTreeDto::getProject));
        for (Map.Entry<Project, List<FolderTreeDto>> folderTreesByProjectMap : map.entrySet()) {
            Project project = folderTreesByProjectMap.getKey();
            List<FolderTreeDto> list = folderTreesByProjectMap.getValue();
            Collections.sort(list);
            ProjectTreeDto dto = new ProjectTreeDto(project.getId(), project.getName(), list);
            projTree.add(dto);
        }
        Collections.sort(projTree);
        return projTree;
    }

    private List<ProjectTreeDto> appendProjectTreesWithoutFolderList(List<Long> projectIds) {
        ArrayList<ProjectTreeDto> projTree = new ArrayList<ProjectTreeDto>();
        Map<Long, String> projectNameByIdMap = this.projectService.findNamesByProjectIds(projectIds);
        projectNameByIdMap.forEach((projectId, projectName) -> {
            ProjectTreeDto dto = new ProjectTreeDto((Long)projectId, (String)projectName, (List<FolderTreeDto>)new ArrayList<FolderTreeDto>());
            projTree.add(dto);
        });
        Collections.sort(projTree);
        return projTree;
    }

    @GetMapping(value={"/campaign-folders/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="executions[id]")
    public ResponseEntity<PagedModel<EntityModel<IssueDto>>> findCampaignFoldersIssues(@PathVariable(value="id") long id, Pageable pageable) {
        List<Long> executionIds = this.service.getExecutionIdsByCampaignFolder(id);
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(executionIds, pageable);
        PagedModel res = this.pageAssembler.toModel(pagedIssue);
        return ResponseEntity.ok((Object)res);
    }
}

