/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.validators.helper.CampaignDtoValidationHelper;

@Component
public class CampaignPatchValidator
implements Validator {
    private static final String NON_PATCHABLE_ATTRIBUTE = "non patchable attribute";
    @Inject
    private CampaignDtoValidationHelper campaignDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return CampaignDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        CampaignDto patch = (CampaignDto)target;
        boolean exists = this.campaignDtoValidationHelper.checkEntityExist(errors, RestType.CAMPAIGN, patch.getId());
        if (!exists) {
            return;
        }
        this.campaignDtoValidationHelper.loadProject(patch);
        if (patch.getStatus() != null) {
            this.campaignDtoValidationHelper.checkAndAssignStatus(errors, patch);
        }
        this.campaignDtoValidationHelper.checkCufs(errors, patch, BindableEntity.CAMPAIGN);
        this.checkForbiddenPatchAttributes(errors, patch);
    }

    private void checkForbiddenPatchAttributes(Errors errors, CampaignDto post) {
        if (post.getIterations() != null) {
            errors.rejectValue("iterations", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the campaign itself can be posted. The attribute iterations cannot be posted. Use direct url to the iterations entity instead");
        }
        if (post.getMilestones() != null) {
            errors.rejectValue("milestones", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the campaign itself can be posted. The attribute milestones cannot be posted. Use direct url to the milestones entity instead");
        }
        if (post.getTestPlans() != null) {
            errors.rejectValue("test-plan", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the campaign itself can be posted. The attribute test plan cannot be posted. Use direct url to the test plan entity instead");
        }
    }
}

