/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.service.RestAutomatedTestResultImportService;
import org.squashtest.tm.plugin.rest.service.RestFeatureAvailabilityService;
import org.squashtest.tm.plugin.rest.validators.ResultPostValidator;
import org.squashtest.tm.service.internal.dto.resultimport.ExecutionResultDto;
import org.squashtest.tm.service.internal.dto.resultimport.PartialErrorDto;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestAutomatedTestResultImportController
extends BaseRestController {
    private final RestAutomatedTestResultImportService restAutomatedTestResultImportService;
    private final ResultPostValidator resultPostValidator;
    private final RestFeatureAvailabilityService restFeatureAvailabilityService;

    @Inject
    public RestAutomatedTestResultImportController(RestAutomatedTestResultImportService restAutomatedTestResultImportService, ResultPostValidator resultPostValidator, RestFeatureAvailabilityService restFeatureAvailabilityService) {
        this.restAutomatedTestResultImportService = restAutomatedTestResultImportService;
        this.resultPostValidator = resultPostValidator;
        this.restFeatureAvailabilityService = restFeatureAvailabilityService;
    }

    @PostMapping(value={"/import/results/{iteration_id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Object> importResultsFromPipeline(@PathVariable(value="iteration_id") long iterationId, @RequestBody ExecutionResultDto executionResultDto) throws BindException {
        this.restFeatureAvailabilityService.denyFeatureForCloudPremium();
        this.validatePostResults(executionResultDto);
        PartialErrorDto partialError = this.restAutomatedTestResultImportService.importResultsForIteration(iterationId, executionResultDto);
        if (partialError.getTests().isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.status((int)207).body((Object)EntityModel.of((Object)partialError));
    }

    private void validatePostResults(ExecutionResultDto dto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)dto, "post-execution-result-import");
        this.resultPostValidator.validate(dto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(dto, errors, "post-execution-result-import");
    }
}

