/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import jakarta.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.users.UsersGroup;
import org.squashtest.tm.plugin.rest.jackson.model.UserDto;
import org.squashtest.tm.service.internal.repository.UsersGroupDao;

@Component
public class PartyValidationHelper {
    private static final String GROUP_NAME_ADMIN = "admin";
    private static final String GROUP_NAME_USER = "user";
    private static final String GROUP_NAME_TECHNICAL_ACCOUNT = "technicalAccount";
    @Inject
    private UsersGroupDao groupDao;

    public void checkAndAssignValues(Errors errors, UserDto userDto) {
        String groupName = userDto.getGroup().getQualifiedName();
        if (GROUP_NAME_ADMIN.equalsIgnoreCase(groupName)) {
            UsersGroup group = this.groupDao.findByQualifiedName("squashtest.authz.group.core.Admin");
            userDto.setGroupId(group.getId());
        } else if (GROUP_NAME_USER.equalsIgnoreCase(groupName)) {
            UsersGroup group = this.groupDao.findByQualifiedName("squashtest.authz.group.tm.User");
            userDto.setGroupId(group.getId());
        } else if (GROUP_NAME_TECHNICAL_ACCOUNT.equalsIgnoreCase(groupName)) {
            UsersGroup group = this.groupDao.findByQualifiedName("squashtest.authz.group.tm.TechnicalAccount");
            userDto.setGroupId(group.getId());
        } else {
            errors.rejectValue("group", "invalid group", "Invalid group value for this user. ");
        }
    }
}

