/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import java.util.Set;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.project.GenericProject;

public class ExecutionValidationHelper {
    private Errors errors;
    private GenericProject project;
    private Execution execution;

    public ExecutionValidationHelper(Execution execution, GenericProject project, Errors errors) {
        this.execution = execution;
        this.project = project;
        this.errors = errors;
    }

    public void validate() {
        this.checkStatus();
    }

    private void checkStatus() {
        ExecutionStatus status = this.execution.getExecutionStatus();
        Set disabledStatuses = this.project.getCampaignLibrary().getDisabledStatuses();
        if (disabledStatuses.contains(status)) {
            this.errors.rejectValue("wrapped.executionStatus", "Unauthorized execution status", "This execution status is not authorized for this project.");
        }
    }
}

