/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import org.jooq.DSLContext;
import org.jooq.Select;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.core.exception.IllegalPremiumFeatureAccessException;
import org.squashtest.tm.plugin.rest.jackson.model.ConvertRequirementTo;
import org.squashtest.tm.plugin.rest.repository.RestRequirementRepository;
import org.squashtest.tm.plugin.rest.service.RestRequirementService;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.requirement.HighLevelRequirementConversionService;

@Service
@Transactional
public class RestRequirementServiceImpl
implements RestRequirementService {
    private final RestRequirementRepository restRequirementRepository;
    private final HighLevelRequirementConversionService highLevelRequirementConversionService;
    private DSLContext dslContext;
    private PluginFinderService pluginFinderService;

    public RestRequirementServiceImpl(RestRequirementRepository restRequirementRepository, HighLevelRequirementConversionService highLevelRequirementConversionService, DSLContext dslContext, PluginFinderService pluginFinderService) {
        this.restRequirementRepository = restRequirementRepository;
        this.highLevelRequirementConversionService = highLevelRequirementConversionService;
        this.dslContext = dslContext;
        this.pluginFinderService = pluginFinderService;
    }

    @Override
    public Requirement convertRequirement(ConvertRequirementTo convertRequirementTo, Long requirementId) {
        if (!this.pluginFinderService.isPremiumPluginInstalled()) {
            throw new IllegalPremiumFeatureAccessException();
        }
        this.doUpdateRequirementNature(convertRequirementTo, requirementId);
        return (Requirement)this.restRequirementRepository.getReferenceById(requirementId);
    }

    private void doUpdateRequirementNature(ConvertRequirementTo convertRequirementTo, Long requirementId) {
        Boolean isHighLevel = this.isHighLevel(requirementId);
        if (ConvertRequirementTo.STANDARD_REQUIREMENT == convertRequirementTo && isHighLevel.booleanValue()) {
            this.highLevelRequirementConversionService.convertIntoStandardRequirement(requirementId.longValue());
        } else if (ConvertRequirementTo.HIGH_LEVEL_REQUIREMENT == convertRequirementTo && !isHighLevel.booleanValue()) {
            this.highLevelRequirementConversionService.convertIntoHighLevelRequirement(requirementId.longValue());
        }
    }

    private Boolean isHighLevel(Long requirementId) {
        return this.dslContext.fetchExists((Select)DSL.selectOne().from((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).where(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Object)requirementId)));
    }
}

