/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller.helper;

import jakarta.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyClearance;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyPermission;
import org.squashtest.tm.plugin.rest.jackson.model.RestUserPermission;

@Component
public class ResourceLinksHelper {
    private static final String ATTACHMENTS = "attachments";
    private static final String CONTENT = "content";
    @Inject
    private BasePathAwareLinkBuildingService linkService;

    public void addAllLinksForPartyClearance(Long projectId, EntityModel<RestPartyClearance> res) {
        res.add(this.linkService.createRelationTo(GenericProject.class, projectId.longValue(), "self", "/clearances"));
    }

    public void addAllLinksForPartyPermission(Long projectId, EntityModel<RestPartyPermission> res) {
        res.add(this.linkService.createRelationTo(GenericProject.class, projectId.longValue(), "self", "/permissions"));
    }

    public void addAllLinksForUserClearance(Long userID, EntityModel<RestPartyClearance> res) {
        res.add(this.linkService.createRelationTo(User.class, userID.longValue(), "self", "/clearances"));
    }

    public void addAllLinksForUserPermission(Long userID, EntityModel<RestUserPermission> res) {
        res.add(this.linkService.createRelationTo(User.class, userID.longValue(), "self", "/permissions"));
    }

    public void addAllLinksForDataset(EntityModel<Dataset> res) {
        Dataset ds = (Dataset)res.getContent();
        if (ds != null) {
            res.add(this.linkService.createLinkTo((Identified)ds.getTestCase()));
        }
    }

    public void addAllLinksForTestCaseFolder(EntityModel<TestCaseFolder> res) {
        TestCaseFolder cf = (TestCaseFolder)res.getContent();
        if (cf != null) {
            res.add(this.linkService.createLinkTo((Identified)cf.getProject()));
            res.add(this.linkService.createRelationTo((Identified)cf, CONTENT));
            res.add(this.linkService.createRelationTo((Identified)cf, ATTACHMENTS));
        }
    }

    public void addAllLinksForCampaignFolder(EntityModel<CampaignFolder> res) {
        CampaignFolder cf = (CampaignFolder)res.getContent();
        if (cf != null) {
            res.add(this.linkService.createLinkTo((Identified)cf.getProject()));
            res.add(this.linkService.createRelationTo((Identified)cf, CONTENT));
            res.add(this.linkService.createRelationTo((Identified)cf, ATTACHMENTS));
        }
    }

    public void addAllLinksForRequirementFolder(EntityModel<RequirementFolder> res) {
        RequirementFolder cf = (RequirementFolder)res.getContent();
        if (cf != null) {
            res.add(this.linkService.createLinkTo((Identified)cf.getProject()));
            res.add(this.linkService.createRelationTo((Identified)cf, CONTENT));
            res.add(this.linkService.createRelationTo((Identified)cf, ATTACHMENTS));
        }
    }

    public void addAllLinksForExecution(EntityModel<Execution> res) {
        Execution exec = (Execution)res.getContent();
        if (exec != null) {
            if (!this.hasSelfLink(res)) {
                res.add(this.linkService.createSelfLink((Identified)exec));
            }
            res.add(this.linkService.createLinkTo((Identified)exec.getProject()));
            res.add(this.linkService.createLinkTo((Identified)exec.getTestPlanItem(), "test_plan_item"));
            if (exec.getExecutionMode() != TestCaseExecutionMode.EXPLORATORY) {
                res.add(this.linkService.createRelationTo((Identified)exec, "execution-steps"));
            }
            res.add(this.linkService.createRelationTo((Identified)exec, ATTACHMENTS));
        }
    }

    public void addAllLinksForTestCase(EntityModel<TestCase> res) {
        TestCase tc = (TestCase)res.getContent();
        if (tc != null) {
            res.add(this.linkService.createLinkTo((Identified)tc.getProject()));
            res.add(this.linkService.createRelationTo((Identified)tc, "steps"));
            res.add(this.linkService.createRelationTo((Identified)tc, "parameters"));
            res.add(this.linkService.createRelationTo((Identified)tc, "datasets"));
            res.add(this.linkService.createRelationTo((Identified)tc, ATTACHMENTS));
        }
    }

    public void addAllLinksForTestSuite(EntityModel<TestSuite> res) {
        TestSuite ts = (TestSuite)res.getContent();
        if (ts != null) {
            res.add(this.linkService.createLinkTo((Identified)ts.getProject()));
            res.add(this.linkService.createLinkTo((Identified)ts.getIteration()));
            res.add(this.linkService.createRelationTo((Identified)ts, "test-plan"));
            res.add(this.linkService.createRelationTo((Identified)ts, ATTACHMENTS));
        }
    }

    public void addAllLinksForRequirement(EntityModel<Requirement> res) {
        Requirement requirement = (Requirement)res.getContent();
        if (requirement != null) {
            res.add(this.linkService.createLinkTo((Identified)requirement.getCurrentVersion().getProject()));
            res.add(this.linkService.createRelationTo((Identified)requirement.getCurrentVersion(), "current_version"));
        }
    }

    public void populateLinks(EntityModel<TestStep> res) {
        TestStep step = (TestStep)res.getContent();
        if (step != null) {
            res.add(this.linkService.createLinkTo((Identified)step.getTestCase()));
        }
    }

    public void addAllLinksForIteration(EntityModel<Iteration> res) {
        Iteration iteration = (Iteration)res.getContent();
        if (iteration != null) {
            res.add(this.linkService.createLinkTo((Identified)iteration.getProject()));
            res.add(this.linkService.createLinkTo((Identified)iteration.getCampaign()));
            res.add(this.linkService.createRelationTo((Identified)iteration, "test-suites"));
            res.add(this.linkService.createRelationTo((Identified)iteration, "test-plan"));
            res.add(this.linkService.createRelationTo((Identified)iteration, ATTACHMENTS));
        }
    }

    public void addAllLinksForTestPlanItem(EntityModel<TestPlanItem> res) {
        TestPlanItem tpi = (TestPlanItem)res.getContent();
        if (tpi != null) {
            res.add(this.linkService.createLinkTo((Identified)tpi.getProject()));
            if (tpi.getReferencedTestCase() != null) {
                res.add(this.linkService.createLinkTo((Identified)tpi.getReferencedTestCase()));
            }
            if (tpi.getReferencedDataset() != null) {
                res.add(this.linkService.createLinkTo((Identified)tpi.getReferencedDataset()));
            }
            if (tpi.getExploratorySessionOverview() != null) {
                res.add(this.linkService.createLinkTo((Identified)tpi.getExploratorySessionOverview()));
            }
            if (tpi.getTestPlan().getParentIteration() != null) {
                res.add(this.linkService.createLinkTo((Identified)tpi.getTestPlan().getParentIteration()));
            }
            res.add(this.linkService.createRelationTo((Identified)tpi, "executions"));
        }
    }

    public void addAllLinksForCampaignTestPlanItem(EntityModel<CampaignTestPlanItem> res) {
        CampaignTestPlanItem ctpi = (CampaignTestPlanItem)res.getContent();
        if (ctpi != null) {
            res.add(this.linkService.createLinkTo((Identified)ctpi.getProject()));
            if (ctpi.getReferencedTestCase() != null) {
                res.add(this.linkService.createLinkTo((Identified)ctpi.getReferencedTestCase()));
            }
            if (ctpi.getReferencedDataset() != null) {
                res.add(this.linkService.createLinkTo((Identified)ctpi.getReferencedDataset()));
            }
            res.add(this.linkService.createLinkTo((Identified)ctpi.getCampaign()));
        }
    }

    private boolean hasSelfLink(EntityModel<?> res) {
        return res.getLink(IanaLinkRelations.SELF).isPresent();
    }

    public void addAllLinksForExploratorySessionOverview(EntityModel<ExploratorySessionOverview> res) {
        TestPlanItem itp;
        ExploratorySessionOverview exploSession = (ExploratorySessionOverview)res.getContent();
        if (exploSession != null && (itp = exploSession.getTestPlanItem()) != null) {
            this.addExploratorySessionLinks(res, itp);
        }
    }

    public void addAllLinksForExploratoryExecution(EntityModel<ExploratoryExecution> res) {
        ExploratoryExecution exec = (ExploratoryExecution)res.getContent();
        if (exec != null) {
            if (!this.hasSelfLink(res)) {
                res.add(this.linkService.createSelfLink(ExploratoryExecution.class, exec.getId()));
            }
            res.add(this.linkService.createLinkTo((Identified)exec.getTestPlanItem(), "test_plan_item"));
            res.add(this.linkService.createLinkTo((Identified)exec.getProject()));
            res.add(this.linkService.createLinkTo((Identified)exec.getTestPlanItem().getExploratorySessionOverview(), "exploratory_session"));
            res.add(this.linkService.createRelationTo((Identified)exec, ATTACHMENTS));
        }
    }

    private void addExploratorySessionLinks(EntityModel<ExploratorySessionOverview> res, TestPlanItem itp) {
        res.add(this.linkService.createLinkTo((Identified)itp.getProject()));
        if (itp.getReferencedTestCase() != null) {
            res.add(this.linkService.createLinkTo((Identified)itp.getReferencedTestCase()));
        }
        res.add(this.linkService.createLinkTo((Identified)itp.getTestPlan().getParentIteration()));
    }

    public void addAllLinksForSessionNote(EntityModel<SessionNote> res) {
        SessionNote note = (SessionNote)res.getContent();
        if (note != null) {
            if (!this.hasSelfLink(res)) {
                res.add(this.linkService.createSelfLink(SessionNote.class, note.getId()));
            }
            res.add(this.linkService.createLinkTo((Identified)note.getProject()));
            res.add(this.linkService.createLinkTo((Identified)note.getExecution(), "exploratory_execution"));
            res.add(this.linkService.createRelationTo((Identified)note, ATTACHMENTS));
        }
    }
}

