/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.FolderTreeDto;
import org.squashtest.tm.plugin.rest.jackson.model.ParentFolderTreeDto;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectTreeDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseFolderDto;
import org.squashtest.tm.plugin.rest.service.RestProjectService;
import org.squashtest.tm.plugin.rest.service.RestTestCaseFolderService;
import org.squashtest.tm.plugin.rest.validators.TestCaseFolderPatchValidator;
import org.squashtest.tm.plugin.rest.validators.TestCaseFolderPostValidator;

@RestApiController(value=TestCaseFolder.class)
@UseDefaultRestApiConfiguration
public class RestTestCaseFolderController
extends BaseRestController {
    @Inject
    private RestTestCaseFolderService service;
    @Inject
    private TestCaseFolderPostValidator testCaseFolderPostValidator;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private TestCaseFolderPatchValidator testCaseFolderPatchValidator;
    @Inject
    private RestProjectService projectService;

    @GetMapping(value={"/test-case-folders"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedModel<EntityModel<TestCaseFolder>>> findAllReadableTestCaseFolders(Pageable pageable) {
        Page<TestCaseFolder> folders = this.service.findAllReadable(pageable);
        PagedModel res = this.toPagedModel(folders);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/test-case-folders/tree/{projectIds}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<List<ProjectTreeDto>> findTestCaseFoldersTreeByProjects(@PathVariable(value="projectIds") List<Long> projectIds) {
        ArrayList<Long> alreadyAddedIds = new ArrayList<Long>();
        List<Long> readableProjectIds = this.projectService.getReadableProjectIdsOnTestCaseLibrary(projectIds);
        List<TestCaseFolder> folders = this.service.findAllByProjectIds(readableProjectIds);
        List<ParentFolderTreeDto> tree = this.getTestCaseFolderTree(folders, alreadyAddedIds);
        List<ProjectTreeDto> projTree = this.buildProjectTreeFromParentFolders(tree, readableProjectIds);
        return ResponseEntity.ok(projTree);
    }

    @GetMapping(value={"/test-case-folders/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<EntityModel<TestCaseFolder>> findTestCaseFolder(@PathVariable(value="id") long id) {
        TestCaseFolder folder = this.service.getOne(id);
        EntityModel res = this.toEntityModel((Identified)folder);
        res.add(this.createLinkTo((Identified)folder.getProject()));
        res.add(this.createRelationTo("content"));
        res.add(this.createRelationTo("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/test-case-folders/{id}/content"})
    @ResponseBody
    @DynamicFilterExpression(value="name,reference")
    public ResponseEntity<PagedModel<EntityModel<TestCaseLibraryNode>>> findTestCaseFolderContent(@PathVariable(value="id") long folderId, @SortDefault(sort={"nodes.id"}, direction=Sort.Direction.ASC) Pageable pageable, ContentInclusion include) {
        Page<TestCaseLibraryNode> content = null;
        switch (include) {
            case NESTED: {
                content = this.service.findFolderAllContent(folderId, pageable);
                break;
            }
            default: {
                content = this.service.findFolderContent(folderId, pageable);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(content, "content");
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/test-case-folders"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<EntityModel<TestCaseFolder>> createCampaignFolder(@RequestBody TestCaseFolderDto folderDto) throws BindException {
        this.testCaseFolderPostValidator.validatePostTestCaseFolder(folderDto);
        TestCaseFolder folder = this.service.addTestCaseFolder(folderDto);
        EntityModel res = this.toEntityModel((Identified)folder);
        this.linksHelper.addAllLinksForTestCaseFolder((EntityModel<TestCaseFolder>)res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/test-case-folders/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<EntityModel<TestCaseFolder>> patchTestCaseFolder(@RequestBody TestCaseFolderDto folderPatch, @PathVariable(value="id") long id) throws BindException {
        folderPatch.setId(id);
        this.testCaseFolderPatchValidator.validatePatchTestCaseFolder(folderPatch);
        TestCaseFolder folder = this.service.patchTestCaseFolder(folderPatch, id);
        EntityModel res = this.toEntityModel((Identified)folder);
        this.linksHelper.addAllLinksForTestCaseFolder((EntityModel<TestCaseFolder>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/test-case-folders/{ids}"})
    @ResponseBody
    public ResponseEntity<Void> deleteTestCaseFolder(@PathVariable(value="ids") List<Long> folderIds) {
        this.service.deleteFolder(folderIds);
        return ResponseEntity.noContent().build();
    }

    private List<ParentFolderTreeDto> getTestCaseFolderTree(List<TestCaseFolder> folders, List<Long> alreadyAddedIds) {
        ArrayList<ParentFolderTreeDto> listDto = new ArrayList<ParentFolderTreeDto>();
        for (TestCaseFolder folder : folders) {
            if (alreadyAddedIds.contains(folder.getId())) continue;
            ParentFolderTreeDto dto = new ParentFolderTreeDto();
            dto.setType("test-case-folder");
            dto.setProject(folder.getProject());
            dto.setId(folder.getId());
            dto.setName(folder.getName());
            dto.setUrl(this.createSelfLink((Identified)folder).getHref());
            dto.setChildren(Collections.emptyList());
            if (folder.hasContent()) {
                List<TestCaseFolder> folderChildren = this.getAllTestCaseFolderFromContent(folder);
                List<ParentFolderTreeDto> tcftd = this.getTestCaseFolderTree(folderChildren, alreadyAddedIds);
                dto.setChildren(tcftd);
            }
            alreadyAddedIds.add(folder.getId());
            listDto.add(dto);
        }
        return listDto;
    }

    private List<TestCaseFolder> getAllTestCaseFolderFromContent(TestCaseFolder folder) {
        ArrayList<TestCaseFolder> testCaseFolderList = new ArrayList<TestCaseFolder>();
        for (TestCaseLibraryNode tcln : folder.getContent()) {
            if (!(tcln instanceof TestCaseFolder)) continue;
            testCaseFolderList.add((TestCaseFolder)tcln);
        }
        return testCaseFolderList;
    }

    private List<ProjectTreeDto> buildProjectTreeFromParentFolders(List<ParentFolderTreeDto> parentFolders, List<Long> projectIds) {
        if (!parentFolders.isEmpty()) {
            return this.appendProjectTreesWithFolderList(parentFolders);
        }
        if (!projectIds.isEmpty()) {
            return this.appendProjectTreesWithoutFolderList(projectIds);
        }
        return Collections.emptyList();
    }

    private List<ProjectTreeDto> appendProjectTreesWithFolderList(List<ParentFolderTreeDto> tree) {
        ArrayList<ProjectTreeDto> projTree = new ArrayList<ProjectTreeDto>();
        Map<Project, List<FolderTreeDto>> map = tree.stream().collect(Collectors.groupingBy(FolderTreeDto::getProject));
        for (Map.Entry<Project, List<FolderTreeDto>> folderTreesByProjectMap : map.entrySet()) {
            Project project = folderTreesByProjectMap.getKey();
            List<FolderTreeDto> list = folderTreesByProjectMap.getValue();
            Collections.sort(list);
            ProjectTreeDto dto = new ProjectTreeDto(project.getId(), project.getName(), list);
            projTree.add(dto);
        }
        Collections.sort(projTree);
        return projTree;
    }

    private List<ProjectTreeDto> appendProjectTreesWithoutFolderList(List<Long> projectIds) {
        ArrayList<ProjectTreeDto> projTree = new ArrayList<ProjectTreeDto>();
        Map<Long, String> projectNameByIdMap = this.projectService.findNamesByProjectIds(projectIds);
        projectNameByIdMap.forEach((projectId, projectName) -> {
            ProjectTreeDto dto = new ProjectTreeDto((Long)projectId, (String)projectName, (List<FolderTreeDto>)new ArrayList<FolderTreeDto>());
            projTree.add(dto);
        });
        Collections.sort(projTree);
        return projTree;
    }
}

