/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.service.RestAutomatedExecutionExtenderService;

@RestApiController(value=AutomatedExecutionExtender.class)
@UseDefaultRestApiConfiguration
public class RestAutomatedExecutionExtenderController
extends BaseRestController {
    @Inject
    private RestAutomatedExecutionExtenderService automatedExecutionService;

    @GetMapping(value={"/automated-execution-extenders/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*,execution[name],automated_test[name]")
    public ResponseEntity<EntityModel<AutomatedExecutionExtender>> findAutomatedExecutionExtender(@PathVariable(value="id") long id) {
        AutomatedExecutionExtender extender = this.automatedExecutionService.getOne(id);
        EntityModel res = this.toEntityModel((Identified)extender);
        return ResponseEntity.ok((Object)res);
    }
}

