/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.service.impl;

import jakarta.inject.Inject;
import java.util.Objects;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.plugin.rest.core.service.NodeHierarchyHelpService;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.CampaignLibraryDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryDao;
import org.squashtest.tm.service.internal.repository.SprintGroupDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;

@Transactional(readOnly=true)
public class NodeHierarchyHelpServiceImpl
implements NodeHierarchyHelpService {
    @Inject
    private TestCaseLibraryDao tclibDao;
    @Inject
    private TestCaseFolderDao tcfoldDao;
    @Inject
    private CampaignLibraryDao campaignLibraryDao;
    @Inject
    private RequirementLibraryDao reqlibDao;
    @Inject
    private RequirementFolderDao reqfoldDao;
    @Inject
    private CampaignFolderDao campaignFolderDao;
    @Inject
    private SprintGroupDao sprintGroupDao;
    @Inject
    private RequirementDao reqDao;

    @Override
    public NodeContainer<? extends LibraryNode> findParentFor(TestCaseLibraryNode tcnode) {
        TestCaseFolder fold = (TestCaseFolder)this.tcfoldDao.findByContent((LibraryNode)tcnode);
        return fold != null ? fold : this.tclibDao.findByRootContent((LibraryNode)tcnode);
    }

    @Override
    public NodeContainer<? extends LibraryNode> findParentFor(RequirementLibraryNode<?> reqNode) {
        Folder container = null;
        container = this.reqfoldDao.findByContent(reqNode);
        if (container == null) {
            container = this.reqlibDao.findByRootContent(reqNode);
        }
        if (container == null && Requirement.class.isAssignableFrom(reqNode.getClass())) {
            container = this.reqDao.findByContent((Requirement)reqNode);
        }
        return container;
    }

    @Override
    public NodeContainer<? extends LibraryNode> findParentFor(CampaignLibraryNode cln) {
        Folder container = this.campaignFolderDao.findByContent((LibraryNode)cln);
        if (Objects.isNull(container)) {
            container = this.sprintGroupDao.findByContent((LibraryNode)cln);
        }
        return Objects.nonNull(container) ? container : this.campaignLibraryDao.findByRootContent((LibraryNode)cln);
    }
}

