/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.SprintDto;
import org.squashtest.tm.plugin.rest.validators.helper.SprintDtoValidationHelper;

@Component
public class SprintPostValidator
implements Validator {
    @Inject
    SprintDtoValidationHelper sprintDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return SprintDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        SprintDto sprintDto = (SprintDto)target;
        if (sprintDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing sprint, please do a patch request to the sprint id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        this.sprintDtoValidationHelper.checkParent(errors, sprintDto, RestType.SPRINT);
        this.sprintDtoValidationHelper.checkSprintDates(errors, sprintDto);
        this.sprintDtoValidationHelper.checkCreateSprintStatus(errors, sprintDto);
    }

    public void validateRequirements(long sprintId, List<Long> requirementIds, String errorMessage) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        SprintDto sprintDto = new SprintDto();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)sprintDto, errorMessage);
        this.sprintDtoValidationHelper.checkEntityExist((Errors)validationBean, RestType.SPRINT, sprintId);
        for (Long id : requirementIds) {
            this.sprintDtoValidationHelper.checkEntityExist((Errors)validationBean, RestType.REQUIREMENT, id);
        }
        if (validationBean.hasErrors()) {
            errors.add((Errors)validationBean);
        }
        ErrorHandlerHelper.throwIfError(sprintDto, errors, errorMessage);
    }
}

