/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.squashtest.tm.domain.testcase.DatasetParamValue;

public class TestCaseDatasetParamValueSerializer
extends StdSerializer<Collection<DatasetParamValue>> {
    public static final Comparator<DatasetParamValue> ID_COMPARATOR = new Comparator<DatasetParamValue>(){

        @Override
        public int compare(DatasetParamValue p, DatasetParamValue q) {
            if (p.getParameter().getId() == q.getParameter().getId()) {
                return p.getParameter().getName().compareTo(q.getParameter().getName());
            }
            if (p.getParameter().getId() > q.getParameter().getId()) {
                return 1;
            }
            return -1;
        }
    };

    public TestCaseDatasetParamValueSerializer() {
        super(TypeFactory.defaultInstance().constructType(Collection.class));
    }

    public void serialize(Collection<DatasetParamValue> datasetParamValues, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this.doSerialize(datasetParamValues, gen);
    }

    private void doSerialize(Collection<DatasetParamValue> datasetParamValues, JsonGenerator gen) throws IOException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ArrayList<DatasetParamValue> listDatasetParamValue = new ArrayList<DatasetParamValue>(datasetParamValues);
        Collections.sort(listDatasetParamValue, ID_COMPARATOR);
        gen.writeStartArray();
        for (DatasetParamValue datasetParamValue : listDatasetParamValue) {
            attributes.put("parameter_id", datasetParamValue.getParameter().getId());
            attributes.put("parameter_name", datasetParamValue.getParameter().getName());
            attributes.put("parameter_value", datasetParamValue.getParamValue());
            attributes.put("parameter_test_case_id", datasetParamValue.getParameter().getTestCase().getId());
            gen.writeObject(attributes);
        }
        gen.writeEndArray();
    }
}

