/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.TeamDto;
import org.squashtest.tm.plugin.rest.service.RestPartyService;
import org.squashtest.tm.plugin.rest.validators.PartyPatchValidator;
import org.squashtest.tm.plugin.rest.validators.PartyPostValidator;

@RestApiController(value=Team.class)
@UseDefaultRestApiConfiguration
public class RestTeamController
extends BaseRestController {
    @Inject
    private RestPartyService restPartyService;
    @Inject
    private PartyPostValidator partyPostValidator;
    @Inject
    private PartyPatchValidator partyPatchValidator;

    @GetMapping(value={"/teams/{id}"})
    @EntityGetter
    @DynamicFilterExpression(value="*, members[*, -teams]")
    public ResponseEntity<EntityModel<Team>> findTeam(@PathVariable(value="id") long teamId) {
        Team team = this.restPartyService.findTeamByPartyId(teamId);
        EntityModel res = this.toEntityModel((Identified)team);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/teams"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedModel<EntityModel<Team>>> findAllTeams(Pageable pageable) {
        Page<Team> pagedTeams = this.restPartyService.findAllTeams(pageable);
        PagedModel res = this.toPagedModel(pagedTeams);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/teams"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<Team>> createTeam(@RequestBody TeamDto teamDto) throws BindException {
        this.validatePostTeam(teamDto);
        Team team = (Team)this.restPartyService.createParty(teamDto);
        EntityModel res = this.toEntityModel((Identified)team);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/teams/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, members[*, -teams]")
    public ResponseEntity<EntityModel<Team>> patchTeam(@RequestBody TeamDto patch, @PathVariable(value="id") long id) throws BindException {
        patch.setId(id);
        this.validatePatchTeam(patch);
        Team team = (Team)this.restPartyService.patchParty(patch, id);
        EntityModel res = this.toEntityModel((Identified)team);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/teams/{ids}"})
    public ResponseEntity<Void> deleteTeams(@PathVariable(value="ids") List<Long> teamIds) {
        this.restPartyService.deleteTeams(teamIds);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/teams/{teamId}/members"})
    @ResponseBody
    @DynamicFilterExpression(value="*, -teams")
    public ResponseEntity<PagedModel<EntityModel<User>>> findTeamMembers(@PathVariable(value="teamId") long teamId, Pageable pageable) {
        Page<User> users = this.restPartyService.findAllTeamMembers(teamId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(users, "members");
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/teams/{teamId}/members"})
    @ResponseBody
    public ResponseEntity<Void> addMembersToTeam(@PathVariable(value="teamId") long teamId, @RequestParam(value="userIds") List<Long> userIds) {
        this.restPartyService.addMembersToTeam(teamId, userIds);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/teams/{teamId}/members"})
    @ResponseBody
    public ResponseEntity<Void> removeMembersFromTeam(@PathVariable(value="teamId") long teamId, @RequestParam(value="userIds") List<Long> userIds) {
        this.restPartyService.removeMembersFromTeam(teamId, userIds);
        return ResponseEntity.noContent().build();
    }

    private void validatePostTeam(TeamDto teamDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)teamDto, "post-team");
        this.partyPostValidator.validate(teamDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(teamDto, errors, "post-team");
    }

    private void validatePatchTeam(TeamDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, "patch-team");
        this.partyPatchValidator.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, "patch-team");
    }
}

