/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.ParameterDto;
import org.squashtest.tm.plugin.rest.service.RestParameterService;
import org.squashtest.tm.plugin.rest.validators.ParameterValidator;

@RestApiController(value=Parameter.class)
@UseDefaultRestApiConfiguration
public class RestParameterController
extends BaseRestController {
    @Inject
    private RestParameterService restParameterService;
    @Inject
    private ParameterValidator parameterValidator;

    @GetMapping(value={"/parameters/{id}"})
    @EntityGetter
    @DynamicFilterExpression(value="*,name,test_case[name]")
    public ResponseEntity<EntityModel<Parameter>> findParameter(@PathVariable(value="id") long id) {
        Parameter p = this.restParameterService.getOne(id);
        EntityModel res = EntityModel.of((Object)p);
        res.add(this.createSelfLink((Identified)p));
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/parameters"})
    @ResponseBody
    @DynamicFilterExpression(value="*,name,test_case[name]")
    public ResponseEntity<EntityModel<Parameter>> postParameter(@RequestBody ParameterDto parameterDto) throws BindException {
        this.parameterValidator.validatePostParameter(parameterDto);
        Parameter parameter = this.restParameterService.addParameter(parameterDto);
        EntityModel res = this.toEntityModel((Identified)parameter);
        res.add(this.createSelfLink((Identified)parameter));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/parameters/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*,name,test_case[name]")
    public ResponseEntity<EntityModel<Parameter>> modifyParameter(@RequestBody ParameterDto parameterDto, @PathVariable(value="id") Long parameterId) throws BindException {
        this.parameterValidator.validatePatchParameter(parameterDto, parameterId);
        Parameter parameter = this.restParameterService.modifyParameter(parameterDto);
        EntityModel res = this.toEntityModel((Identified)parameter);
        res.add(this.createSelfLink((Identified)parameter));
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/parameters/{id}"})
    public ResponseEntity<Void> deleteParameter(@PathVariable(value="id") Long parameterId) {
        this.restParameterService.deleteParameter(parameterId);
        return ResponseEntity.noContent().build();
    }
}

