/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseFolderDto;
import org.squashtest.tm.plugin.rest.validators.helper.TestCaseFolderDtoValidationHelper;

@Component
public class TestCaseFolderPostValidator
implements Validator {
    private static final String POST_TESTCASE_FOLDER = "post-testCase-folder";
    @Inject
    private TestCaseFolderDtoValidationHelper testCaseFolderDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return TestCaseFolderDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        TestCaseFolderDto folderDto = (TestCaseFolderDto)target;
        if (folderDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing test case folder, please do a patch request to the test case folder id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        this.testCaseFolderDtoValidationHelper.checkParent(errors, folderDto, RestType.TEST_CASE_FOLDER);
        if (errors.hasErrors()) {
            return;
        }
        this.testCaseFolderDtoValidationHelper.assignProject(folderDto);
        this.testCaseFolderDtoValidationHelper.checkCufs(errors, folderDto, BindableEntity.TESTCASE_FOLDER);
    }

    public void validatePostTestCaseFolder(TestCaseFolderDto folderDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)folderDto, POST_TESTCASE_FOLDER);
        this.validate(folderDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(folderDto, errors, POST_TESTCASE_FOLDER);
    }
}

