/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.plugin.rest.core.jackson.SerializationDynamicFilter;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestCustomFieldMembers;
import org.squashtest.tm.plugin.rest.service.ExternalDataHandler;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;

@Component
public class CustomFieldValuesPropertyWriter
extends VirtualBeanPropertyWriter {
    @Inject
    private CustomFieldValueFinderService cufServices;
    @Inject
    private ExternalDataHandler externalDataHandler;

    public CustomFieldValuesPropertyWriter() {
    }

    public CustomFieldValuesPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, ExternalDataHandler externalDataHandler, CustomFieldValueFinderService cufServices) {
        super(propDef, contextAnnotations, declaredType);
        this.externalDataHandler = externalDataHandler;
        this.cufServices = cufServices;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        RestCustomFieldMembers customFieldValueDtos = new RestCustomFieldMembers();
        List<CustomFieldValue> customFieldValues = this.getCustomFieldValues(bean);
        List<CustomFieldValue> filtered = this.applyFilter(customFieldValues, prov);
        for (CustomFieldValue customFieldValue : filtered) {
            CustomField customField = customFieldValue.getCustomField();
            customFieldValueDtos.add(new CustomFieldValueDto(customField, customFieldValue));
        }
        return customFieldValueDtos;
    }

    private List<CustomFieldValue> getCustomFieldValues(Object bean) {
        List<CustomFieldValue> values = this.externalDataHandler.getExternalData(bean, "custom_fields");
        if (values == null) {
            return this.cufServices.findAllCustomFieldValues((BoundEntity)bean);
        }
        return values;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new CustomFieldValuesPropertyWriter(propDef, declaringClass.getAnnotations(), type, this.externalDataHandler, this.cufServices);
    }

    private List<CustomFieldValue> applyFilter(List<CustomFieldValue> orig, SerializerProvider provider) {
        SerializationDynamicFilter filter = this.findFilter(orig, provider);
        if (filter == null) {
            return orig;
        }
        filter = filter.forCurrentBean();
        ArrayList<CustomFieldValue> newlist = new ArrayList<CustomFieldValue>();
        for (CustomFieldValue value : orig) {
            if (!filter.include(value.getCustomField().getCode())) continue;
            newlist.add(value);
        }
        return newlist;
    }

    private SerializationDynamicFilter findFilter(List<CustomFieldValue> cufs, SerializerProvider provider) {
        FilterProvider filterProvider = provider.getConfig().getFilterProvider();
        if (filterProvider != null) {
            try {
                PropertyFilter filter = filterProvider.findPropertyFilter((Object)"squashrest", cufs);
                if (filter != null && SerializationDynamicFilter.class.isAssignableFrom(filter.getClass())) {
                    return (SerializationDynamicFilter)filter;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }
}

