/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.service.RestDatasetService;
import org.squashtest.tm.plugin.rest.validators.DatasetValidator;

@RestApiController(value=Dataset.class)
@UseDefaultRestApiConfiguration
public class RestDatasetController
extends BaseRestController {
    @Inject
    private RestDatasetService restDatasetService;
    @Inject
    private DatasetValidator datasetValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @GetMapping(value={"/datasets/{id}"})
    @EntityGetter
    @DynamicFilterExpression(value="*,parameters[name],test_case[name]")
    public ResponseEntity<EntityModel<Dataset>> findDataset(@PathVariable(value="id") long id) {
        Dataset dataset = this.restDatasetService.getOne(id);
        EntityModel res = EntityModel.of((Object)dataset);
        res.add(this.createSelfLink((Identified)dataset));
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/datasets"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<Dataset>> addDataset(@RequestBody DatasetDto datasetDto) throws BindException {
        List<Parameter> listAllParamByIdTc = this.restDatasetService.findAllParametersByTc(datasetDto.getReferencedTestCase().getId());
        this.datasetValidator.validationPostDataset(datasetDto, listAllParamByIdTc);
        Dataset dataset = this.restDatasetService.addDataset(datasetDto, listAllParamByIdTc);
        EntityModel res = this.toEntityModel((Identified)dataset);
        this.linksHelper.addAllLinksForDataset((EntityModel<Dataset>)res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/datasets/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<Dataset>> modifyDataset(@RequestBody DatasetDto datasetDto, @PathVariable(value="id") long datasetId) throws BindException {
        this.datasetValidator.validationPatchDataset(datasetDto, datasetId);
        Dataset dataset = this.restDatasetService.modifyDataset(datasetDto, datasetId);
        EntityModel res = this.toEntityModel((Identified)dataset);
        this.linksHelper.addAllLinksForDataset((EntityModel<Dataset>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/datasets/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> removeDataset(@PathVariable(value="id") Long datasetId) {
        this.restDatasetService.deleteDataset(datasetId);
        return ResponseEntity.noContent().build();
    }
}

