/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.AutomatedSuiteDto;
import org.squashtest.tm.plugin.rest.service.RestAutomatedExecutionExtenderService;
import org.squashtest.tm.plugin.rest.service.RestAutomatedSuiteService;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestAutomatedSuiteController
extends BaseRestController {
    @Inject
    private RestAutomatedSuiteService automatedSuiteService;
    @Inject
    private RestAutomatedExecutionExtenderService automatedExecutionExtenderService;
    private final AutomatedSuiteResourceAssembler suiteResourceAssembler = new AutomatedSuiteResourceAssembler();

    @GetMapping(value={"/automated-suites"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<PagedModel<EntityModel<AutomatedSuiteDto>>> findAllReadableAutomatedSuites(Pageable pageable) {
        Page<AutomatedSuite> suites = this.automatedSuiteService.findAllReadable(pageable);
        Page suiteDtos = suites.map(suite -> new AutomatedSuiteDto(suite.getUuid(), suite.getExecutionExtenders()));
        PagedModel res = this.pageAssembler.toModel(suiteDtos, (RepresentationModelAssembler)this.suiteResourceAssembler);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/automated-suites/{uuid}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<AutomatedSuiteDto>> findAutomatedSuite(@PathVariable(value="uuid") String uuid) {
        AutomatedSuite suite = this.automatedSuiteService.findByUuid(uuid);
        EntityModel<AutomatedSuiteDto> res = this.toEntityModel(suite);
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        res.add(Link.of((String)builder.toUriString(), (LinkRelation)LinkRelation.of((String)"self")));
        builder.path("/executions");
        res.add(Link.of((String)builder.toUriString(), (LinkRelation)LinkRelation.of((String)"executions")));
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/automated-suites/{uuid}/executions"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<PagedModel<EntityModel<AutomatedExecutionExtender>>> findAutomatedSuiteExecutions(@PathVariable(value="uuid") String uuid, Pageable pageable) {
        Long automatedSuiteId = this.automatedSuiteService.findByUuid(uuid).getId();
        Page<AutomatedExecutionExtender> executions = this.automatedExecutionExtenderService.findAutomatedExecutionExtenderByAutomatedSuiteId(automatedSuiteId, pageable);
        PagedModel res = this.toPagedModel(executions);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/automated-suite-utils/from-iteration-test-plan-items"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<AutomatedSuiteDto>> createAutomatedSuiteFromIterationTestPlanItems(@RequestParam(value="itemIds") List<Long> itemIds) {
        AutomatedSuite suite = this.automatedSuiteService.createAutomatedSuiteFromIterationTestPlanItems(itemIds);
        EntityModel<AutomatedSuiteDto> res = this.toEntityModel(suite);
        this.addAllLinksForAutomatedSuite(suite.getUuid(), res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(res);
    }

    @PostMapping(value={"/automated-suite-utils/from-test-suite"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<AutomatedSuiteDto>> createAutomatedSuiteFromTestSuite(@RequestParam(value="testSuiteId") long testSuiteId) {
        AutomatedSuite suite = this.automatedSuiteService.createAutomatedSuiteFromTestSuite(testSuiteId);
        EntityModel<AutomatedSuiteDto> res = this.toEntityModel(suite);
        this.addAllLinksForAutomatedSuite(suite.getUuid(), res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(res);
    }

    @PostMapping(value={"/automated-suite-utils/from-iteration"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<AutomatedSuiteDto>> createAutomatedSuiteFromIteration(@RequestParam(value="iterationId") long iterationId) {
        AutomatedSuite suite = this.automatedSuiteService.createAutomatedSuiteFromIteration(iterationId);
        EntityModel<AutomatedSuiteDto> res = this.toEntityModel(suite);
        this.addAllLinksForAutomatedSuite(suite.getUuid(), res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(res);
    }

    @PostMapping(value={"/automated-suite-utils/{uuid}/executor"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<AutomatedSuiteDto>> executeAutomatedSuite(@PathVariable(value="uuid") String uuid) {
        AutomatedSuite suite = this.automatedSuiteService.findByUuid(uuid);
        this.automatedSuiteService.start(suite);
        EntityModel<AutomatedSuiteDto> res = this.toEntityModel(suite);
        this.addAllLinksForAutomatedSuite(suite.getUuid(), res);
        return ResponseEntity.ok(res);
    }

    private EntityModel<AutomatedSuiteDto> toEntityModel(AutomatedSuite suite) {
        AutomatedSuiteDto suiteDto = new AutomatedSuiteDto(suite.getUuid(), suite.getExecutionExtenders());
        return EntityModel.of((Object)suiteDto);
    }

    private void addAllLinksForAutomatedSuite(String suiteId, EntityModel<AutomatedSuiteDto> res) {
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestAutomatedSuiteController)((Object)WebMvcLinkBuilder.methodOn(RestAutomatedSuiteController.class, (Object[])new Object[0]))).findAutomatedSuite(suiteId)));
        res.add(Link.of((String)builder.toString(), (LinkRelation)LinkRelation.of((String)"self")));
        res.add(Link.of((String)builder.slash((Object)"/executions").toString(), (LinkRelation)LinkRelation.of((String)"executions")));
    }

    private class AutomatedSuiteResourceAssembler
    implements RepresentationModelAssembler<AutomatedSuiteDto, EntityModel<AutomatedSuiteDto>> {
        private AutomatedSuiteResourceAssembler() {
        }

        public EntityModel<AutomatedSuiteDto> toModel(AutomatedSuiteDto entity) {
            EntityModel res = EntityModel.of((Object)entity);
            RestAutomatedSuiteController.this.addAllLinksForAutomatedSuite(entity.getId(), (EntityModel<AutomatedSuiteDto>)res);
            return res;
        }
    }
}

