/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(["jquery", "backbone", "underscore", "handlebars", "./abstractStepView", "search/SearchDateWidget", "search/SearchMultiAutocompleteWidget"],
	function($, backbone, _, Handlebars, AbstractStepView) {
	"use strict";

	var simpleCriteriaStepView = AbstractStepView.extend({

		initialize: function(data, wizrouter) {
			this.tmpl = "#simple-criteria-step-tpl";
			this.model = data;
			this.model.set({ "advancedCriteria": undefined });
			data.name = "simpleCriteriaStep";
			this._initialize(data, wizrouter);
		},

		prepareUI: function() {

            // NOOP
		},

		reloadDataInView: function() {

			var emptySimpleCriteria = {
			    keepFailed: true,
			    keepBlocked: true,
			    keepIssued: true,
			    keepNonRegression: true
			};

			var simpleCriteria = this.model.get("simpleCriteria") || emptySimpleCriteria;

			// Update the View here.
			$("#keep-failed").prop('checked', simpleCriteria.keepFailed);
			$("#keep-blocked").prop('checked', simpleCriteria.keepBlocked);
			$("#keep-issued").prop('checked', simpleCriteria.keepIssued);
			$("#keep-non-regression").prop('checked', simpleCriteria.keepNonRegression);
},

		updateModel : function() {

            var keepFailed = this.$el.find("#keep-failed").is(":checked");
            var keepBlocked = this.$el.find("#keep-blocked").is(":checked");
            var keepIssued = this.$el.find("#keep-issued").is(":checked");
            var keepNonRegression = this.$el.find("#keep-non-regression").is(":checked");

			// Get information here.
			var simpleCriteria = {
			    keepFailed: keepFailed,
			    keepBlocked: keepBlocked,
			    keepIssued: keepIssued,
			    keepNonRegression: keepNonRegression
			};


			this.model.set({
                simpleCriteria: simpleCriteria
			});
		},

        /** Updates the model with the test plan matching the simple criteria in the model. */
        updateTestPlan: function() {
            var self = this;
            self._loadPreviewTestPlan().done(function(model) {
                self.model.set({
                    testPlan: model.aaData
                });
            });
        },

        /** Ajax Sync. method. Returns the promise to fetch the test plan based on the simple criteria. */
		_loadPreviewTestPlan: function() {

            var simpleCriteria = this.model.get("simpleCriteria");

            var replicationParameters = this.model.get("replicationParameters");
            var iterationId = replicationParameters.iterationId;

            var simpleCriteria = {
                iterationId: iterationId,
                keepTestSuites: replicationParameters.keepTestSuites,
                keepAssignees: replicationParameters.keepAssignees,
                keepFailed: simpleCriteria.keepFailed,
                keepBlocked: simpleCriteria.keepBlocked,
                keepIssued: simpleCriteria.keepIssued,
                keepNonRegression: simpleCriteria.keepNonRegression
            }

            var dataString = JSON.stringify(simpleCriteria);

            return $.ajax({
                method: "POST",
                contentType: "application/json",
                url: squashtm.app.contextRoot + "campaign-assistant/iteration-replication/preview",
                data: dataString,
                async: false
            });
        }

	});

	return simpleCriteriaStepView;

});
