/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(["jquery", "backbone", "underscore", "app/squash.handlebars.helpers"],
	function($, backbone, _, Handlebars) {
	"use strict";
	
	var sideView = Backbone.View.extend({
		el : "#side-view",

		initialize : function(data) {
			this.tmpl = "#side-view-tpl";
			this.model = data;
			this.render(data);

			var validSteps = this.getValidSteps();
			
			var invalidSteps = this.getInvalidSteps(validSteps, data.name); 
			
			_.each(invalidSteps , function(step){	
				$("#step-icon-" + step).addClass("wizard-step-fail");
			});

			_.each(validSteps, function(step){	
				$("#step-icon-" + step).addClass("wizard-step-ok");
				$("#step-" + step).addClass("nota-bene");
			});
			
			$("#step-icon-" + data.name).attr('class', '');
			$("#step-icon-" + data.name).addClass("wizard-step-current");
			$("#step-" + data.name).addClass("normal-warning-message");
			
		},
		
		getInvalidSteps : function(validSteps, currStepName){

			var steps = this.model.get("steps");
			
			var currStepNumber = _.chain(steps)
			.where({name : currStepName})
			.pluck('stepNumber')
			.first()
			.value();
			
			var invalidStep = _.chain(steps)
			.filter(function(step){return step.stepNumber < currStepNumber;})
			.pluck('name')
			.difference(validSteps)
			.value();
			
			return invalidStep;
			
		},		

		getValidSteps : function (data){
			
			var self = this;
			var steps = self.model.get("steps");
			return _.chain(steps)
			    .filter(function(step) { return self.isStepValid(step) })
			    .pluck("name")
			    .value();
			
		},

		isStepValid: function(step) {
		    var self = this;
		    var result = true;
		    var neededParams = step.validationParameters;
		    _.each(neededParams, function(param) {
		        var value = self.model.get(param);
		        if(value === undefined) result = false;
		    });
		    return result;

		},

        isModelAttrEqual: function(attrName, expectedValue) {
            var value = this.model.get(attrName);
            return value === expectedValue;
        },

        /* Filters steps in order to have distinct step names. (i.e. avoid to have 'Criteria' name twice)
        ** If two parallel steps exist, it chooses according to the 'determinant' attribute of this step,
        *  if the determinant is not set, just pick the first of the parallel steps.*/
        getFilteredSteps: function(steps) {
            var self = this;
            var groupedSteps = _.groupBy(steps, function(step) { return step.stepNumber });
            var distinctSteps =
                _.map(groupedSteps, function(stepsOfSameNumber) {
                    if(stepsOfSameNumber.length === 1) {
                        return stepsOfSameNumber[0];
                    } else {
                        var chosenStep = _.find(stepsOfSameNumber, function(step) {
                            var det = step.determinant;
                            return self.isModelAttrEqual(det.attribute, det.value);
                        });
                    return !!chosenStep ? chosenStep : stepsOfSameNumber[0];
                    }
                });
            return distinctSteps;
        },

		render : function(data, tmpl) {
            var distinctSteps = this.getFilteredSteps(data.attributes.steps);
            var adaptedData = {steps: distinctSteps};

 		    var src = $(this.tmpl).html();
			this.template = Handlebars.compile(src);

			this.$el.append(this.template(adaptedData));

			return this;
		},
		
		destroy_view: function() {

		    this.undelegateEvents();
		    this.$el.removeData().unbind(); 
		    this.remove();  
		    Backbone.View.prototype.remove.call(this);
		}
		
	});

	return sideView;

});