/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.service;

import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.User;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestClientException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementVersionLink;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.redminereq.client.RedmineClient;
import org.squashtest.tm.plugin.redminereq.domain.Configuration;
import org.squashtest.tm.plugin.redminereq.domain.FieldLink;
import org.squashtest.tm.plugin.redminereq.domain.FilterBinding;
import org.squashtest.tm.plugin.redminereq.domain.ImportStatus;
import org.squashtest.tm.plugin.redminereq.exceptions.SynchronizationException;
import org.squashtest.tm.plugin.redminereq.importer.ImporterState;
import org.squashtest.tm.plugin.redminereq.importer.RedmineRequirementImporter;
import org.squashtest.tm.plugin.redminereq.service.ConfigurationService;
import org.squashtest.tm.plugin.redminereq.service.EffectiveConfiguration;
import org.squashtest.tm.plugin.redminereq.service.PluginDao;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Service(value="squash.tm.plugin.redminereq.synchronizationService")
@Transactional
public class SynchronizationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizationService.class);
    private final List<Long> linkedRVIdsToUnlink = new ArrayList<Long>();
    private final Map<Long, Boolean> linkedRVIds = new HashMap<Long, Boolean>();
    private final Map<Integer, Integer> relIds = new HashMap<Integer, Integer>();
    @Inject
    private Provider<RedmineClient> clientProvider;
    @Inject
    private Provider<RedmineRequirementImporter> importerProvider;
    @Inject
    private BugTrackerFinderService serverService;
    @Inject
    private ConfigurationService confService;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private LinkedRequirementVersionManagerService linkedRequirementVersionManagerService;
    @Inject
    private PluginDao pluginDao;
    @Inject
    private CustomFieldBindingModificationService cufBindingService;
    @Inject
    private InternationalizationHelper inHelper;
    @Inject
    private RequirementVersionManagerService versionService;
    @PersistenceContext
    private EntityManager entityManager;

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public ImportStatus synchronizeProject(Long projectId) {
        ImporterState state;
        block14: {
            LOGGER.trace("initiating synchronization");
            Configuration conf = this.confService.getConfigurationForProject(projectId);
            LOGGER.trace("initiating synchronization client");
            Long serverId = conf.getServerId();
            RedmineClient client = null;
            state = new ImporterState();
            ArrayList<FilterBinding> filters = new ArrayList<FilterBinding>(conf.getFilterBindings());
            if (filters.isEmpty()) {
                state.setHasAllFetchFailed(true);
            } else {
                try {
                    try {
                        HibernateConfig.enableBatch((EntityManager)this.entityManager, (int)50);
                        client = this.createRedmineClient(serverId);
                        EffectiveConfiguration effective = client.createEffectiveConfiguration(conf);
                        List cufsForProjectReq = this.cufBindingService.findCustomFieldsForGenericProject(projectId.longValue());
                        List<ExtendedCustomField> allRedmineCufs = client.getAllRedmineCufs();
                        RedmineRequirementImporter importer = this.createImporter(serverId, projectId, effective);
                        importer.setState(state);
                        ArrayList<Map<Issue, RequirementVersionInstruction>> squashReqs = new ArrayList<Map<Issue, RequirementVersionInstruction>>();
                        int count = 0;
                        for (FilterBinding f : filters) {
                            List<Issue> issues = client.getIssuesForFilter(f);
                            if (issues.isEmpty()) {
                                state.setHadFailureOnFilterFetch(true);
                                ++count;
                            }
                            squashReqs.add(importer.importRedmineTickets(issues, f, projectId, client, allRedmineCufs, cufsForProjectReq));
                        }
                        if (!state.isHadFailureOnFilterFetch()) {
                            importer.deleteLeftoverRequirements(projectId);
                        }
                        state.setHasAllFetchFailed(count == filters.size());
                        Map<Issue, RequirementVersionInstruction> squashReqsMap = this.getSquashRequirements(squashReqs);
                        LOGGER.trace("associate links to requirements");
                        this.associateLinksToSquashReqs(client, squashReqsMap, conf, projectId);
                    }
                    catch (RestClientException exception) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("encountered exception on fetch, which will be added to the synchronization report : ", (Throwable)exception);
                        }
                        state.setHadFailureOnFilterFetch(true);
                        if (client != null) {
                            client.close();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        client.close();
                    }
                    throw throwable;
                }
                if (client != null) {
                    client.close();
                }
            }
        }
        return state.toImportStatus();
    }

    private void associateLinksToSquashReqs(RedmineClient client, Map<Issue, RequirementVersionInstruction> squashReqs, Configuration conf, Long projectId) {
        List<String> closedStatus = client.getClosedStatus(conf);
        List<FieldLink> fieldLinks = this.getConfiguredFieldLinks(projectId);
        List requirementVersionLinkTypes = this.linkedRequirementVersionManagerService.getAllReqVersionLinkTypes();
        for (Issue issue : squashReqs.keySet()) {
            RequirementVersionInstruction instruction = squashReqs.get(issue);
            this.findAllLinkedRVIds(instruction);
            this.createAllLinks(issue, fieldLinks, closedStatus, client, squashReqs, requirementVersionLinkTypes);
            this.deleteLinks(instruction);
            this.synchronizeAudit(issue, squashReqs);
        }
    }

    private void createAllLinks(Issue issue, List<FieldLink> fieldLinks, List<String> closedStatus, RedmineClient client, Map<Issue, RequirementVersionInstruction> squashReqs, List<RequirementVersionLinkType> requirementVersionLinkTypes) {
        block18: {
            if (issue.getParentId() == null && issue.getRelations().isEmpty()) break block18;
            for (FieldLink f : fieldLinks) {
                RequirementVersionLinkType typeParent = this.getTypeParent(f, requirementVersionLinkTypes);
                if ("PARENT".equals(f.getId())) {
                    if (issue.getParentId() == null) continue;
                    this.createLinkForParent(issue, client, closedStatus, squashReqs, typeParent);
                    continue;
                }
                if (issue.getRelations().isEmpty()) continue;
                switch (f.getId()) {
                    case "BLOCKS": {
                        this.createLink(issue, "blocks", squashReqs, client, closedStatus, typeParent);
                        break;
                    }
                    case "DUPLICATES": {
                        this.createLink(issue, "duplicates", squashReqs, client, closedStatus, typeParent);
                        break;
                    }
                    case "PRECEDES": {
                        this.createLink(issue, "precedes", squashReqs, client, closedStatus, typeParent);
                        break;
                    }
                    case "COPIED": {
                        this.createLink(issue, "copied_to", squashReqs, client, closedStatus, typeParent);
                        break;
                    }
                    default: {
                        this.createLink(issue, "relates", squashReqs, client, closedStatus, typeParent);
                    }
                }
            }
        }
    }

    private void deleteLinks(RequirementVersionInstruction instruction) {
        for (Long id : this.linkedRVIds.keySet()) {
            if (!this.linkedRVIds.get(id).equals(false)) continue;
            this.linkedRVIdsToUnlink.add(id);
        }
        if (!this.linkedRVIdsToUnlink.isEmpty() && instruction.getMode().equals((Object)ImportMode.UPDATE)) {
            this.pluginDao.deleteLinkedRequirementVersion(instruction.getRequirementVersion().getId(), this.linkedRVIdsToUnlink);
        }
        this.linkedRVIdsToUnlink.clear();
        this.linkedRVIds.clear();
    }

    private void findAllLinkedRVIds(RequirementVersionInstruction instruction) {
        if (instruction.getMode().equals((Object)ImportMode.UPDATE)) {
            Long reqVersionId = instruction.getRequirementVersion().getId();
            RequirementVersion reqVersion = this.versionService.findById(reqVersionId.longValue());
            Set links = reqVersion.getRequirementVersionLinks();
            for (RequirementVersionLink link : links) {
                if (reqVersionId.equals(link.getLinkedRequirementVersion().getId())) {
                    this.linkedRVIds.put(link.getRelatedLinkedRequirementVersion().getId(), false);
                    continue;
                }
                if (!reqVersionId.equals(link.getRelatedLinkedRequirementVersion().getId())) continue;
                this.linkedRVIds.put(link.getLinkedRequirementVersion().getId(), false);
            }
        }
    }

    private void synchronizeAudit(Issue issue, Map<Issue, RequirementVersionInstruction> squashReqs) {
        squashReqs.get(issue).getRequirementVersion().setCreatedOn(issue.getCreatedOn());
        User author = issue.getAuthor();
        StringBuilder createdBy = new StringBuilder();
        if (author.getFirstName() != null && author.getLastName() != null) {
            createdBy = createdBy.append(author.getFirstName()).append(" ").append(author.getLastName());
        } else if (author.getFirstName() != null) {
            createdBy.append(author.getFirstName());
        } else {
            createdBy.append("-");
        }
        squashReqs.get(issue).getRequirementVersion().setCreatedBy(createdBy.toString());
        if (issue.getCreatedOn().equals(issue.getUpdatedOn())) {
            squashReqs.get(issue).getRequirementVersion().setLastModifiedBy(null);
            squashReqs.get(issue).getRequirementVersion().setLastModifiedOn(null);
        } else {
            squashReqs.get(issue).getRequirementVersion().setLastModifiedBy("-");
            squashReqs.get(issue).getRequirementVersion().setLastModifiedOn(issue.getUpdatedOn());
        }
        squashReqs.get(issue).getRequirementVersion().setSkipModifyAudit(true);
    }

    private void createLinkForParent(Issue issue, RedmineClient client, List<String> closedStatus, Map<Issue, RequirementVersionInstruction> squashReqs, RequirementVersionLinkType typeParent) {
        Issue parentIssue = client.getIssueById(issue.getParentId());
        boolean hasClosedStatus = false;
        for (String status : closedStatus) {
            if (!status.equals(issue.getStatusName()) && !status.equals(parentIssue.getStatusName())) continue;
            hasClosedStatus = true;
        }
        if (parentIssue != null && squashReqs.containsKey(parentIssue) && !hasClosedStatus) {
            this.linkedRequirementVersionManagerService.addOrUpdateRequirementLink(squashReqs.get(parentIssue).getRequirementVersion().getId(), squashReqs.get(issue).getRequirementVersion().getId(), typeParent.getRole2Code());
            for (Long id : this.linkedRVIds.keySet()) {
                if (!id.equals(squashReqs.get(parentIssue).getRequirementVersion().getId())) continue;
                this.linkedRVIds.put(id, true);
            }
        }
    }

    private void createLink(Issue issue, String relationType, Map<Issue, RequirementVersionInstruction> squashReqs, RedmineClient client, List<String> closedStatus, RequirementVersionLinkType typeParent) {
        for (IssueRelation issRel : issue.getRelations()) {
            Issue issueToRel = client.getIssueById(issRel.getIssueToId());
            Issue issueRel = client.getIssueById(issRel.getIssueId());
            if (!issRel.getIssueToId().equals(this.relIds.get(issue.getId())) && !issue.getId().equals(this.relIds.get(issRel.getIssueToId())) && issRel.getType().equals(relationType)) {
                boolean hasClosedStatus = false;
                for (String status : closedStatus) {
                    if (!status.equals(issueRel.getStatusName()) && !status.equals(issueToRel.getStatusName())) continue;
                    hasClosedStatus = true;
                }
                if (squashReqs.containsKey(issueRel) && squashReqs.containsKey(issueToRel) && !hasClosedStatus) {
                    this.linkedRequirementVersionManagerService.addOrUpdateRequirementLink(squashReqs.get(issueRel).getRequirementVersion().getId(), squashReqs.get(issueToRel).getRequirementVersion().getId(), typeParent.getRole2Code());
                    this.relIds.put(issRel.getIssueId(), issRel.getIssueToId());
                    this.relIds.put(issRel.getIssueToId(), issRel.getIssueId());
                }
            }
            if (squashReqs.get(issueRel) == null || squashReqs.get(issueToRel) == null) continue;
            for (Long id : this.linkedRVIds.keySet()) {
                if (!id.equals(squashReqs.get(issueRel).getRequirementVersion().getId()) && !id.equals(squashReqs.get(issueToRel).getRequirementVersion().getId())) continue;
                this.linkedRVIds.put(id, true);
            }
        }
    }

    private RequirementVersionLinkType getTypeParent(FieldLink f, List<RequirementVersionLinkType> requirementVersionLinkTypes) {
        int nb1 = f.getSquashField().indexOf("(");
        int nb2 = f.getSquashField().lastIndexOf("-");
        String parentCode = f.getSquashField().substring(nb1 + 1, nb2 - 1);
        for (RequirementVersionLinkType type : requirementVersionLinkTypes) {
            if (!type.getRole1Code().equals(parentCode)) continue;
            return type;
        }
        return null;
    }

    private List<FieldLink> getConfiguredFieldLinks(Long projectId) {
        Configuration config = this.pluginDao.getConfigurationForProject(projectId);
        List<FieldLink> fieldLinks = config.getFieldLinks();
        return fieldLinks.stream().filter(fieldLink -> fieldLink.getSquashField() != null && !fieldLink.getSquashField().isEmpty()).collect(Collectors.toList());
    }

    private Map<Issue, RequirementVersionInstruction> getSquashRequirements(List<Map<Issue, RequirementVersionInstruction>> squashReqs) {
        HashMap<Issue, RequirementVersionInstruction> oneMap = new HashMap<Issue, RequirementVersionInstruction>();
        if (squashReqs.size() == 1) {
            return squashReqs.get(0);
        }
        for (Map<Issue, RequirementVersionInstruction> mapped : squashReqs) {
            oneMap.putAll(mapped);
        }
        return oneMap;
    }

    private RedmineClient createRedmineClient(Long serverId) {
        Optional maybeCredentials;
        BugTracker server = this.serverService.findById(serverId.longValue());
        switch (server.getAuthenticationPolicy()) {
            case USER: {
                maybeCredentials = this.credentialsProvider.getCurrentUserCredentials((ThirdPartyServer)server);
                if (!maybeCredentials.isEmpty()) break;
                this.logAndThrowCredentialsError(server.getName());
                break;
            }
            case APP_LEVEL: {
                maybeCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)server);
                if (!maybeCredentials.isEmpty()) break;
                this.logAndThrowCredentialsError(server.getName());
                break;
            }
            default: {
                throw new SynchronizationException("SynchronizationService#createRedmineClient : forgot to implement policy " + server.getAuthenticationPolicy().toString());
            }
        }
        Credentials creds = (Credentials)maybeCredentials.get();
        RedmineClient client = (RedmineClient)this.clientProvider.get();
        client.initialize(server, creds);
        return client;
    }

    private void logAndThrowCredentialsError(String trackerName) {
        String errorMsg = this.inHelper.getMessage("henix.redminereq.validation.invalidcredentials", new Object[]{trackerName}, "", LocaleContextHolder.getLocale());
        throw new RuntimeException(errorMsg);
    }

    private RedmineRequirementImporter createImporter(Long serverId, Long projectId, EffectiveConfiguration effective) {
        Project project = (Project)this.projectDao.getReferenceById((Object)projectId);
        BugTracker server = this.serverService.findById(serverId.longValue());
        RedmineRequirementImporter importer = (RedmineRequirementImporter)this.importerProvider.get();
        importer.setServer(server);
        importer.setProject(project);
        importer.setConfiguration(effective);
        importer.configure();
        return importer;
    }
}

