/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.websso;

import java.security.cert.CertificateEncodingException;
import java.util.List;
import org.opensaml.common.SAMLException;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.KeyInfoConfirmationDataType;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.util.Base64;
import org.springframework.util.Assert;
import sqsaml.org.springframework.security.saml.context.SAMLMessageContext;
import sqsaml.org.springframework.security.saml.util.SAMLUtil;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileConsumer;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileConsumerImpl;

public class WebSSOProfileConsumerHoKImpl
extends WebSSOProfileConsumerImpl
implements WebSSOProfileConsumer {
    @Override
    public String getProfileIdentifier() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:holder-of-key:SSO:browser";
    }

    @Override
    protected void verifySubject(Subject subject, AuthnRequest request, SAMLMessageContext context) throws SAMLException, DecryptionException {
        String userAgentCertificate = this.getUserAgentBase64Certificate(context);
        for (SubjectConfirmation confirmation : subject.getSubjectConfirmations()) {
            NameID nameID;
            if (!"urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(confirmation.getMethod())) continue;
            this.log.debug("Processing Holder-of-Key subject confirmation");
            SubjectConfirmationData data = confirmation.getSubjectConfirmationData();
            if (data == null) {
                this.log.debug("HoK SubjectConfirmation invalidated by missing confirmation data");
                continue;
            }
            if (!(data instanceof KeyInfoConfirmationDataType)) {
                this.log.debug("HoK SubjectConfirmation invalidated by confirmation data not being of KeyInformationDataType type");
                continue;
            }
            KeyInfoConfirmationDataType keyInfoConfirmation = (KeyInfoConfirmationDataType)data;
            boolean foundUserAgent = false;
            block3: for (XMLObject xmlInfo : keyInfoConfirmation.getKeyInfos()) {
                KeyInfo keyInfo = (KeyInfo)xmlInfo;
                List<String> certificates = SAMLUtil.getBase64EncodeCertificates(keyInfo);
                for (String confirmationCert : certificates) {
                    this.log.debug("Comparing user agent certificate {} with certificate in HoK key info {}", (Object)userAgentCertificate, (Object)confirmationCert);
                    if (!userAgentCertificate.equals(confirmationCert)) continue;
                    this.log.debug("User agent certificate confirmed");
                    foundUserAgent = true;
                    break block3;
                }
            }
            if (!foundUserAgent) {
                this.log.debug("HoK SubjectConfirmation invalidated by confirmation keyInfo not corresponding to certificate supplied by user agent");
                continue;
            }
            if (data.getNotBefore() != null && data.getNotBefore().isAfterNow()) {
                this.log.debug("HoK SubjectConfirmation invalidated by notBefore field");
                continue;
            }
            if (data.getNotBefore() != null && data.getNotOnOrAfter().isBeforeNow()) {
                this.log.debug("HoK SubjectConfirmation invalidated by expired notOnOrAfter");
                continue;
            }
            if (request != null && data.getInResponseTo() != null && !data.getInResponseTo().equals(request.getID())) {
                this.log.debug("HoK SubjectConfirmation invalidated by invalid in response to field");
                continue;
            }
            if (data.getRecipient() != null) {
                try {
                    this.verifyEndpoint(context.getLocalEntityEndpoint(), data.getRecipient());
                }
                catch (SAMLException e) {
                    this.log.debug("HoK SubjectConfirmation invalidated by recipient assertion consumer URL, found {}", (Object)data.getRecipient());
                    continue;
                }
            }
            if (subject.getEncryptedID() != null) {
                Assert.notNull((Object)context.getLocalDecrypter(), (String)"Can't decrypt NameID, no decrypter is set in the context");
                nameID = (NameID)context.getLocalDecrypter().decrypt(subject.getEncryptedID());
            } else {
                nameID = subject.getNameID();
            }
            context.setSubjectNameIdentifier(nameID);
            return;
        }
        throw new SAMLException("Assertion invalidated by subject confirmation - can't be confirmed by holder-of-key method");
    }

    protected String getUserAgentBase64Certificate(SAMLMessageContext context) throws SAMLException {
        if (context.getPeerSSLCredential() == null) {
            throw new SAMLException("Cannot verify Holder-of-Key Assertion, peer SSL/TLS credential is not set in the context");
        }
        try {
            return Base64.encodeBytes(context.getPeerSSLCredential().getEntityCertificate().getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new SAMLException("Error base64 encoding peer certificate");
        }
    }
}

