/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.processor;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.common.binding.security.SAMLProtocolMessageXMLSignatureSecurityPolicyRule;
import org.opensaml.saml2.binding.decoding.HTTPSOAP11DecoderImpl;
import org.opensaml.saml2.binding.encoding.HTTPSOAP11Encoder;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.signature.SignatureTrustEngine;
import sqsaml.org.springframework.security.saml.context.SAMLMessageContext;
import sqsaml.org.springframework.security.saml.processor.SAMLBindingImpl;

public class HTTPSOAP11Binding
extends SAMLBindingImpl {
    public HTTPSOAP11Binding(ParserPool parserPool) {
        this(new HTTPSOAP11DecoderImpl(parserPool), new HTTPSOAP11Encoder());
    }

    public HTTPSOAP11Binding(MessageDecoder decoder, MessageEncoder encoder) {
        super(decoder, encoder);
    }

    @Override
    public boolean supports(InTransport transport) {
        if (transport instanceof HttpServletRequestAdapter) {
            HttpServletRequestAdapter t = (HttpServletRequestAdapter)transport;
            HttpServletRequest request = t.getWrappedRequest();
            return "POST".equalsIgnoreCase(t.getHTTPMethod()) && request.getContentType() != null && request.getContentType().startsWith("text/xml");
        }
        return false;
    }

    @Override
    public boolean supports(OutTransport transport) {
        return transport instanceof HTTPOutTransport;
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:SOAP";
    }

    @Override
    public void getSecurityPolicy(List<SecurityPolicyRule> securityPolicy, SAMLMessageContext samlContext) {
        SignatureTrustEngine engine = samlContext.getLocalTrustEngine();
        securityPolicy.add(new SAMLProtocolMessageXMLSignatureSecurityPolicyRule(engine));
    }
}

