/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.parser;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.XMLHelper;
import sqsaml.org.springframework.security.saml.parser.SAMLBase;
import sqsaml.org.springframework.security.saml.util.SAMLUtil;

public class SAMLCollection<T extends XMLObject>
extends SAMLBase<T, List<T>> {
    public SAMLCollection(List<T> object) {
        super(object);
    }

    @Override
    public List<T> getObject() {
        if (this.object == null) {
            this.parse();
        }
        return (List)super.getObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (this.serializedObject == null) {
                ArrayList<String> serializedItems = new ArrayList<String>();
                Iterator iterator = this.getObject().iterator();
                while (iterator.hasNext()) {
                    XMLObject item = (XMLObject)iterator.next();
                    serializedItems.add(XMLHelper.nodeToString(SAMLUtil.marshallMessage(item)));
                }
                this.serializedObject = serializedItems;
            }
            out.writeObject(this.serializedObject);
        }
        catch (MessageEncodingException e) {
            log.error("Error serializing SAML object", (Throwable)e);
            throw new IOException("Error serializing SAML object: " + e.getMessage());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.serializedObject = (ArrayList)in.readObject();
    }

    private void parse() {
        try {
            ArrayList serializedItems = (ArrayList)this.serializedObject;
            if (serializedItems != null) {
                LinkedList items = new LinkedList();
                for (String item : serializedItems) {
                    items.add(this.unmarshallMessage(new StringReader(item)));
                }
                this.object = items;
            }
        }
        catch (MessageDecodingException e) {
            log.error("Error de-serializing SAML object", (Throwable)e);
            throw new RuntimeException("Error de-serializing SAML object: " + e.getMessage());
        }
    }
}

