/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.crypto;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sqsaml.org.owasp.esapi.ESAPI;
import sqsaml.org.owasp.esapi.Logger;
import sqsaml.org.owasp.esapi.crypto.CipherSpec;
import sqsaml.org.owasp.esapi.crypto.CipherTextSerializer;
import sqsaml.org.owasp.esapi.crypto.CryptoHelper;
import sqsaml.org.owasp.esapi.crypto.KeyDerivationFunction;
import sqsaml.org.owasp.esapi.errors.EncryptionException;
import sqsaml.org.owasp.esapi.errors.EnterpriseSecurityRuntimeException;

public final class CipherText
implements Serializable {
    public static final int cipherTextVersion = 20130830;
    private static final long serialVersionUID = 20130830L;
    private static final Logger logger = ESAPI.getLogger("CipherText");
    private CipherSpec cipherSpec_ = null;
    private byte[] raw_ciphertext_ = null;
    private byte[] separate_mac_ = null;
    private long encryption_timestamp_ = 0L;
    private int kdfVersion_ = 20130830;
    private int kdfPrfSelection_ = KeyDerivationFunction.getDefaultPRFSelection();
    private final EnumSet<CipherTextFlags> allCtFlags = EnumSet.of(CipherTextFlags.ALGNAME, new CipherTextFlags[]{CipherTextFlags.CIPHERMODE, CipherTextFlags.PADDING, CipherTextFlags.KEYSIZE, CipherTextFlags.BLOCKSIZE, CipherTextFlags.CIPHERTEXT, CipherTextFlags.INITVECTOR});
    private final EnumSet<CipherTextFlags> fromCipherSpec = EnumSet.of(CipherTextFlags.ALGNAME, CipherTextFlags.CIPHERMODE, CipherTextFlags.PADDING, CipherTextFlags.KEYSIZE, CipherTextFlags.BLOCKSIZE);
    private EnumSet<CipherTextFlags> progress = EnumSet.noneOf(CipherTextFlags.class);

    public CipherText() {
        this.cipherSpec_ = new CipherSpec();
        this.received(this.fromCipherSpec);
    }

    public CipherText(CipherSpec cipherSpec) {
        this.cipherSpec_ = cipherSpec;
        this.received(this.fromCipherSpec);
        if (cipherSpec.getIV() != null) {
            this.received(CipherTextFlags.INITVECTOR);
        }
    }

    public CipherText(CipherSpec cipherSpec, byte[] cipherText) throws EncryptionException {
        this.cipherSpec_ = cipherSpec;
        this.setCiphertext(cipherText);
        this.received(this.fromCipherSpec);
        if (cipherSpec.getIV() != null) {
            this.received(CipherTextFlags.INITVECTOR);
        }
    }

    public static CipherText fromPortableSerializedBytes(byte[] bytes) throws EncryptionException {
        CipherTextSerializer cts = new CipherTextSerializer(bytes);
        return cts.asCipherText();
    }

    public String getCipherTransformation() {
        return this.cipherSpec_.getCipherTransformation();
    }

    public String getCipherAlgorithm() {
        return this.cipherSpec_.getCipherAlgorithm();
    }

    public int getKeySize() {
        return this.cipherSpec_.getKeySize();
    }

    public int getBlockSize() {
        return this.cipherSpec_.getBlockSize();
    }

    public String getCipherMode() {
        return this.cipherSpec_.getCipherMode();
    }

    public String getPaddingScheme() {
        return this.cipherSpec_.getPaddingScheme();
    }

    public byte[] getIV() {
        if (this.isCollected(CipherTextFlags.INITVECTOR)) {
            return this.cipherSpec_.getIV();
        }
        logger.error(Logger.SECURITY_FAILURE, "IV not set yet; unable to retrieve; returning null");
        return null;
    }

    public boolean requiresIV() {
        return this.cipherSpec_.requiresIV();
    }

    public byte[] getRawCipherText() {
        if (this.isCollected(CipherTextFlags.CIPHERTEXT)) {
            byte[] copy = new byte[this.raw_ciphertext_.length];
            System.arraycopy(this.raw_ciphertext_, 0, copy, 0, this.raw_ciphertext_.length);
            return copy;
        }
        logger.error(Logger.SECURITY_FAILURE, "Raw ciphertext not set yet; unable to retrieve; returning null");
        return null;
    }

    public int getRawCipherTextByteLength() {
        if (this.raw_ciphertext_ != null) {
            return this.raw_ciphertext_.length;
        }
        return 0;
    }

    public String getBase64EncodedRawCipherText() {
        return ESAPI.encoder().encodeForBase64(this.getRawCipherText(), false);
    }

    public String getEncodedIVCipherText() {
        if (this.isCollected(CipherTextFlags.INITVECTOR) && this.isCollected(CipherTextFlags.CIPHERTEXT)) {
            byte[] iv = this.getIV();
            byte[] raw = this.getRawCipherText();
            byte[] ivPlusCipherText = new byte[iv.length + raw.length];
            System.arraycopy(iv, 0, ivPlusCipherText, 0, iv.length);
            System.arraycopy(raw, 0, ivPlusCipherText, iv.length, raw.length);
            return ESAPI.encoder().encodeForBase64(ivPlusCipherText, false);
        }
        logger.error(Logger.SECURITY_FAILURE, "Raw ciphertext and/or IV not set yet; unable to retrieve; returning null");
        return null;
    }

    public void computeAndStoreMAC(SecretKey authKey) {
        if (this.macComputed()) {
            String exm = "Programming error: Can't store message authentication code while encrypting; computeAndStoreMAC() called multiple times.";
            throw new EnterpriseSecurityRuntimeException(exm, exm);
        }
        if (!this.collectedAll()) {
            String exm = "Have not collected all required information to compute and store MAC.";
            throw new EnterpriseSecurityRuntimeException(exm, exm);
        }
        byte[] result = this.computeMAC(authKey);
        if (result != null) {
            this.storeSeparateMAC(result);
        }
    }

    void storeSeparateMAC(byte[] macValue) {
        if (!this.macComputed()) {
            this.separate_mac_ = new byte[macValue.length];
            CryptoHelper.copyByteArray(macValue, this.separate_mac_);
            assert (this.macComputed()) : "MAC failed to compute correctly!";
        }
    }

    public boolean validateMAC(SecretKey authKey) {
        boolean requiresMAC = ESAPI.securityConfiguration().useMACforCipherText();
        if (requiresMAC && this.macComputed()) {
            byte[] mac = this.computeMAC(authKey);
            if (mac.length != this.separate_mac_.length) {
                String exm = "MACs are of different lengths. Should both be the same length";
                throw new EnterpriseSecurityRuntimeException(exm, "Possible tampering of MAC? " + exm + "computed MAC len: " + mac.length + ", received MAC len: " + this.separate_mac_.length);
            }
            return MessageDigest.isEqual(mac, this.separate_mac_);
        }
        if (!requiresMAC) {
            return true;
        }
        logger.warning(Logger.SECURITY_FAILURE, "MAC may have been tampered with (e.g., length set to 0).");
        return false;
    }

    public byte[] asPortableSerializedByteArray() throws EncryptionException {
        if (!this.collectedAll()) {
            String msg = "Can't serialize this CipherText object yet as not all mandatory information has been collected";
            throw new EncryptionException("Can't serialize incomplete ciphertext info", msg);
        }
        boolean requiresMAC = ESAPI.securityConfiguration().useMACforCipherText();
        if (requiresMAC && !this.macComputed()) {
            String msg = "Programming error: MAC is required for this cipher mode (" + this.getCipherMode() + "), but MAC has not yet been computed and stored. Call the method computeAndStoreMAC(SecretKey) first before attempting serialization.";
            throw new EncryptionException("Can't serialize ciphertext info: Data integrity issue.", msg);
        }
        return new CipherTextSerializer(this).asSerializedByteArray();
    }

    public void setCiphertext(byte[] ciphertext) throws EncryptionException {
        if (!this.macComputed()) {
            if (ciphertext == null || ciphertext.length == 0) {
                throw new EncryptionException("Encryption faled; no ciphertext", "Ciphertext may not be null or 0 length!");
            }
            if (this.isCollected(CipherTextFlags.CIPHERTEXT)) {
                logger.warning(Logger.SECURITY_FAILURE, "Raw ciphertext was already set; resetting.");
            }
        } else {
            String logMsg = "Programming error: Attempt to set ciphertext after MAC already computed.";
            logger.error(Logger.SECURITY_FAILURE, logMsg);
            throw new EncryptionException("MAC already set; cannot store new raw ciphertext", logMsg);
        }
        this.raw_ciphertext_ = new byte[ciphertext.length];
        CryptoHelper.copyByteArray(ciphertext, this.raw_ciphertext_);
        this.received(CipherTextFlags.CIPHERTEXT);
        this.setEncryptionTimestamp();
    }

    public void setIVandCiphertext(byte[] iv, byte[] ciphertext) throws EncryptionException {
        if (this.isCollected(CipherTextFlags.INITVECTOR)) {
            logger.warning(Logger.SECURITY_FAILURE, "IV was already set; resetting.");
        }
        if (this.isCollected(CipherTextFlags.CIPHERTEXT)) {
            logger.warning(Logger.SECURITY_FAILURE, "Raw ciphertext was already set; resetting.");
        }
        if (!this.macComputed()) {
            if (ciphertext == null || ciphertext.length == 0) {
                throw new EncryptionException("Encryption faled; no ciphertext", "Ciphertext may not be null or 0 length!");
            }
            if (iv == null || iv.length == 0) {
                if (this.requiresIV()) {
                    throw new EncryptionException("Encryption failed -- mandatory IV missing", "Cipher mode " + this.getCipherMode() + " has null or empty IV");
                }
            } else if (iv.length != this.getBlockSize()) {
                throw new EncryptionException("Encryption failed -- bad parameters passed to encrypt", "IV length does not match cipher block size of " + this.getBlockSize());
            }
        } else {
            String logMsg = "MAC already computed from previously set IV and raw ciphertext; may not be reset -- object is immutable.";
            logger.error(Logger.SECURITY_FAILURE, logMsg);
            throw new EncryptionException("Validation of decryption failed.", logMsg);
        }
        this.cipherSpec_.setIV(iv);
        this.received(CipherTextFlags.INITVECTOR);
        this.setCiphertext(ciphertext);
    }

    public int getKDFVersion() {
        return this.kdfVersion_;
    }

    public void setKDFVersion(int vers) {
        CryptoHelper.isValidKDFVersion(vers, false, true);
        this.kdfVersion_ = vers;
    }

    public KeyDerivationFunction.PRF_ALGORITHMS getKDF_PRF() {
        return KeyDerivationFunction.convertIntToPRF(this.kdfPrfSelection_);
    }

    int kdfPRFAsInt() {
        return this.kdfPrfSelection_;
    }

    public void setKDF_PRF(int prfSelection) {
        if (prfSelection < 0 || prfSelection > 15) {
            throw new IllegalArgumentException("kdfPrf == " + prfSelection + " must be between 0 and 15, inclusive.");
        }
        this.kdfPrfSelection_ = prfSelection;
    }

    public long getEncryptionTimestamp() {
        return this.encryption_timestamp_;
    }

    private void setEncryptionTimestamp() {
        if (this.encryption_timestamp_ != 0L) {
            logger.warning(Logger.EVENT_FAILURE, "Attempt to reset non-zero CipherText encryption timestamp to current time!");
        }
        this.encryption_timestamp_ = System.currentTimeMillis();
    }

    void setEncryptionTimestamp(long timestamp) {
        if (timestamp <= 0L) {
            throw new IllegalArgumentException("Timestamp must be greater than zero.");
        }
        if (this.encryption_timestamp_ == 0L) {
            logger.warning(Logger.EVENT_FAILURE, "Attempt to reset non-zero CipherText encryption timestamp to " + new Date(timestamp) + "!");
        }
        this.encryption_timestamp_ = timestamp;
    }

    public byte[] getSeparateMAC() {
        if (this.separate_mac_ == null) {
            return null;
        }
        byte[] copy = new byte[this.separate_mac_.length];
        System.arraycopy(this.separate_mac_, 0, copy, 0, this.separate_mac_.length);
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CipherText: ");
        String creationTime = this.getEncryptionTimestamp() == 0L ? "No timestamp available" : new Date(this.getEncryptionTimestamp()).toString();
        int n = this.getRawCipherTextByteLength();
        String rawCipherText = n > 0 ? "present (" + n + " bytes)" : "absent";
        String mac = this.separate_mac_ != null ? "present" : "absent";
        sb.append("KDF Version: ").append(this.kdfVersion_);
        sb.append(", KDF PRF: ").append(this.kdfPRFAsInt());
        sb.append("; Creation time: ").append(creationTime);
        sb.append("; raw ciphertext is ").append(rawCipherText);
        sb.append("; MAC is ").append(mac).append("; ");
        sb.append(this.cipherSpec_.toString());
        return sb.toString();
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof CipherText) {
            CipherText that = (CipherText)other;
            if (this.collectedAll() && that.collectedAll()) {
                result = that.canEqual(this) && this.cipherSpec_.equals(that.cipherSpec_) && MessageDigest.isEqual(this.raw_ciphertext_, that.raw_ciphertext_) && MessageDigest.isEqual(this.separate_mac_, that.separate_mac_) && this.encryption_timestamp_ == that.encryption_timestamp_;
            } else {
                logger.warning(Logger.EVENT_FAILURE, "CipherText.equals(): Cannot compare two CipherText objects that are not complete, and therefore immutable!");
                logger.info(Logger.EVENT_FAILURE, "This CipherText: " + this.collectedAll() + ";other CipherText: " + that.collectedAll());
                logger.info(Logger.EVENT_FAILURE, "CipherText.equals(): Progress comparison: " + (this.progress == that.progress ? "Same" : "Different"));
                logger.info(Logger.EVENT_FAILURE, "CipherText.equals(): Status this: " + this.progress + "; status other CipherText object: " + that.progress);
                return false;
            }
        }
        return result;
    }

    public int hashCode() {
        if (this.collectedAll()) {
            logger.warning(Logger.EVENT_FAILURE, "CipherText.hashCode(): Cannot compute hachCode() of incomplete CipherText object; object not immutable- returning 0.");
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.cipherSpec_.hashCode());
        sb.append(this.encryption_timestamp_);
        String raw_ct = null;
        String mac = null;
        try {
            raw_ct = new String(this.raw_ciphertext_, "UTF-8");
            mac = new String(this.separate_mac_ != null ? this.separate_mac_ : new byte[]{}, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            raw_ct = new String(this.raw_ciphertext_);
            mac = new String(this.separate_mac_ != null ? this.separate_mac_ : new byte[]{});
        }
        sb.append(raw_ct);
        sb.append(mac);
        return sb.toString().hashCode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CipherText;
    }

    private byte[] computeMAC(SecretKey authKey) {
        if (this.raw_ciphertext_ == null || this.raw_ciphertext_.length == 0) {
            String exm = "Raw ciphertext may not be null or empty.";
            throw new EnterpriseSecurityRuntimeException(exm, exm);
        }
        if (authKey == null || authKey.getEncoded().length == 0) {
            String exm = "Authenticity secret key may not be null or zero length.";
            throw new EnterpriseSecurityRuntimeException(exm, exm);
        }
        try {
            SecretKeySpec sk = new SecretKeySpec(authKey.getEncoded(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(sk);
            if (this.requiresIV()) {
                mac.update(this.getIV());
            }
            byte[] result = mac.doFinal(this.getRawCipherText());
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(Logger.SECURITY_FAILURE, "Cannot compute MAC w/out HmacSHA1.", e);
            return null;
        }
        catch (InvalidKeyException e) {
            logger.error(Logger.SECURITY_FAILURE, "Cannot comput MAC; invalid 'key' for HmacSHA1.", e);
            return null;
        }
    }

    private boolean macComputed() {
        return this.separate_mac_ != null;
    }

    private boolean collectedAll() {
        EnumSet<CipherTextFlags> ctFlags = null;
        if (this.requiresIV()) {
            ctFlags = this.allCtFlags;
        } else {
            EnumSet<CipherTextFlags> initVector = EnumSet.of(CipherTextFlags.INITVECTOR);
            ctFlags = EnumSet.complementOf(initVector);
        }
        boolean result = this.progress.containsAll(ctFlags);
        return result;
    }

    private boolean isCollected(CipherTextFlags flag) {
        return this.progress.contains((Object)flag);
    }

    private void received(CipherTextFlags flag) {
        this.progress.add(flag);
    }

    private void received(EnumSet<CipherTextFlags> ctSet) {
        Iterator it = ctSet.iterator();
        while (it.hasNext()) {
            this.received((CipherTextFlags)((Object)it.next()));
        }
    }

    public int getKDFInfo() {
        int unusedBit28 = 0x8000000;
        int kdfVers = this.getKDFVersion();
        if (!CryptoHelper.isValidKDFVersion(kdfVers, true, false)) {
            String exm = "Invalid KDF version encountered. Value as" + kdfVers;
            throw new EnterpriseSecurityRuntimeException(exm, "Possible tampering of KDF version #? " + exm);
        }
        int kdfInfo = kdfVers;
        int macAlg = this.kdfPRFAsInt();
        if (macAlg < 0 || macAlg > 15) {
            String exm = "Invalid specifier for MAC algorithm: " + macAlg;
            throw new EnterpriseSecurityRuntimeException(exm, "Possible tampering of macAlg specifier? " + exm + "; value should be 0 <= macAlg <= 15.");
        }
        kdfInfo &= 0xF7FFFFFF;
        return kdfInfo |= macAlg << 28;
    }

    private static enum CipherTextFlags {
        ALGNAME,
        CIPHERMODE,
        PADDING,
        KEYSIZE,
        BLOCKSIZE,
        CIPHERTEXT,
        INITVECTOR;

    }
}

