/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.configuration;

import java.io.IOException;
import sqsaml.org.owasp.esapi.configuration.AbstractPrioritizedPropertyLoader;
import sqsaml.org.owasp.esapi.configuration.StandardEsapiPropertyLoader;
import sqsaml.org.owasp.esapi.configuration.XmlEsapiPropertyLoader;
import sqsaml.org.owasp.esapi.configuration.consts.EsapiConfiguration;
import sqsaml.org.owasp.esapi.configuration.consts.EsapiConfigurationType;
import sqsaml.org.owasp.esapi.errors.ConfigurationException;

public class EsapiPropertyLoaderFactory {
    public static AbstractPrioritizedPropertyLoader createPropertyLoader(EsapiConfiguration cfg) throws ConfigurationException, IOException {
        String cfgPath = System.getProperty(cfg.getConfigName());
        if (cfgPath == null || cfgPath.equals("")) {
            return null;
        }
        String fileExtension = cfgPath.substring(cfgPath.lastIndexOf(46) + 1);
        if (EsapiConfigurationType.XML.getTypeName().equalsIgnoreCase(fileExtension)) {
            return new XmlEsapiPropertyLoader(cfgPath, cfg.getPriority());
        }
        if (EsapiConfigurationType.PROPERTIES.getTypeName().equalsIgnoreCase(fileExtension)) {
            return new StandardEsapiPropertyLoader(cfgPath, cfg.getPriority());
        }
        throw new ConfigurationException("The extension of given configuration path [ " + cfgPath + " ] is not supported.Only .xml or .properties file extensions are supported.");
    }
}

